/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.util.ServerUtil;
import aroma1997.world.Config;
import aroma1997.world.DimensionalWorld;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.TeleporterMining;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MiningPortal
extends BlockPortal {
    public MiningPortal() {
        this.func_149663_c("aroma1997sdimension".toLowerCase() + ":miningPortal");
        this.func_149675_a(false);
        this.func_149722_s();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
    }

    public boolean func_176548_d(World worldIn, BlockPos pos) {
        ASize size = new ASize(worldIn, pos, EnumFacing.Axis.X);
        if (size.isValid() && size.portalBlockCount == 0) {
            size.placePortalBlocks();
            return true;
        }
        ASize size1 = new ASize(worldIn, pos, EnumFacing.Axis.Z);
        if (size1.isValid() && size1.portalBlockCount == 0) {
            size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity.func_184187_bx() == null && !entity.func_184207_aI() && entity instanceof EntityPlayerMP) {
            EntityPlayerMP thePlayer = (EntityPlayerMP)entity;
            if (entity.func_70093_af()) {
                if (entity.field_71093_bK != Config.instance.dimensionID) {
                    thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, Config.instance.dimensionID, (Teleporter)new TeleporterMining(thePlayer.field_71133_b.func_71218_a(Config.instance.dimensionID)));
                    thePlayer.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(thePlayer.field_71106_cc, thePlayer.field_71067_cb, thePlayer.field_71068_ca));
                    if (!world.field_72995_K && DimensionalWorld.getWorldMessage() != null) {
                        thePlayer.func_145747_a(ServerUtil.getChatForString((String)DimensionalWorld.getWorldMessage()));
                    }
                } else {
                    thePlayer.field_71133_b.func_184103_al().transferPlayerToDimension(thePlayer, 0, (Teleporter)new TeleporterMining(thePlayer.field_71133_b.func_71218_a(0)));
                    thePlayer.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(thePlayer.field_71106_cc, thePlayer.field_71067_cb, thePlayer.field_71068_ca));
                }
            }
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        ASize size;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (axis == EnumFacing.Axis.X) {
            ASize size2 = new ASize(worldIn, pos, EnumFacing.Axis.X);
            if (!size2.isValid() || size2.portalBlockCount < size2.width * size2.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(axis != EnumFacing.Axis.Z || (size = new ASize(worldIn, pos, EnumFacing.Axis.Z)).isValid() && size.portalBlockCount >= size.width * size.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176550_a});
    }

    public static class ASize {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount = 0;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public ASize(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_) {
            this.world = worldIn;
            this.axis = p_i45694_3_;
            if (p_i45694_3_ == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = p_i45694_2_;
            while (p_i45694_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i45694_2_.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(p_i45694_2_.func_177977_b()), p_i45694_2_.func_177977_b())) {
                p_i45694_2_ = p_i45694_2_.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(p_i45694_2_, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 1 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i)), blockpos) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == DimensionalWorldItems.portalFrame; ++i) {
            }
            Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == DimensionalWorldItems.portalFrame ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    IBlockState state = this.world.func_180495_p(blockpos);
                    Block block = state.func_177230_c();
                    if (!this.isEmptyBlock(state, blockpos)) break block0;
                    if (block == DimensionalWorldItems.aromicPortal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != DimensionalWorldItems.portalFrame : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != DimensionalWorldItems.portalFrame) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == DimensionalWorldItems.portalFrame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 2) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(IBlockState blockIn, BlockPos pos) {
            return blockIn.func_177230_c().isAir(blockIn, (IBlockAccess)this.world, pos) || blockIn.func_177230_c() == DimensionalWorldItems.aromicPortal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 2 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), DimensionalWorldItems.aromicPortal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

