/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.client.util.Colors;
import aroma1997.core.item.AromicCreativeTab;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.util.ItemUtil;
import aroma1997.world.CommonProxy;
import aroma1997.world.Config;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.EventListener;
import aroma1997.world.dimension.WorldProviderMiner;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="aroma1997sdimension", name="Aroma1997sDimension", dependencies="required-after:aroma1997core", acceptedMinecraftVersions="[1.12]")
public class DimensionalWorld {
    @Mod.Instance(value="aroma1997sdimension")
    public static DimensionalWorld instance;
    @SidedProxy(clientSide="aroma1997.world.client.ClientProxy", serverSide="aroma1997.world.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs creativeTabDW;
    public Logger logger;
    public DimensionType dimensionType;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = LogHelperPre.genNewLogger((String)"aroma1997sdimension");
        Config.instance.load();
        AromaRegistry.register(DimensionalWorldItems.class);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (DimensionManager.isDimensionRegistered((int)Config.instance.dimensionID)) {
            throw new RuntimeException("Failed to register the Mining Dimension with the ID " + Config.instance.dimensionID + ". Please pick another one!");
        }
        if (DimensionManager.isDimensionRegistered((int)Config.instance.dimensionID)) {
            throw new RuntimeException("The dimension " + Config.instance.dimensionID + " is already registered. Could not register the mining world to it \n Please change the dimension ID in the Mining World config.");
        }
        this.dimensionType = DimensionType.register((String)"MiningWorld", (String)"_mw", (int)Config.instance.dimensionID, WorldProviderMiner.class, (boolean)false);
        DimensionManager.registerDimension((int)Config.instance.dimensionID, (DimensionType)this.dimensionType);
        WorldProvider provider = DimensionManager.createProviderFor((int)Config.instance.dimensionID);
        if (provider == null || !WorldProviderMiner.class.isInstance(provider)) {
            throw new RuntimeException("The Mining World was registered, but wasn't. This is a severe issue!");
        }
        new EventListener();
        BiomeDictionary.addTypes((Biome)DimensionalWorldItems.miningBiome.get(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        BiomeManager.addStrongholdBiome((Biome)DimensionalWorldItems.miningBiome.get());
        this.logger.log(Level.INFO, "Loaded.");
        this.logger.log(Level.TRACE, "Dimension registered with ID: " + Config.instance.dimensionID + ".");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void worldloaded(FMLServerStartedEvent event) {
    }

    public static ItemStack getHelpBook() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("book.aroma1997sdimension:chapter.general");
        list.add("book.aroma1997sdimension:general.1");
        list.add("book.aroma1997sdimension:general.2");
        list.add("book.aroma1997sdimension:general.3");
        list.add("book.aroma1997sdimension:chapter.blocks");
        list.add("book.aroma1997sdimension:blocks.1");
        list.add("book.aroma1997sdimension:blocks.portalFrame");
        list.add("book.aroma1997sdimension:chapter.items");
        list.add("book.aroma1997sdimension:items.1");
        list.add("book.aroma1997sdimension:items.portalIgniter");
        list.add("book.aroma1997sdimension:items.dimensionChanger");
        list.add("book.aroma1997sdimension:chapter.setupPortal");
        list.add("book.aroma1997sdimension:setupPortal.1");
        list.add("book.aroma1997sdimension:setupPortal.2");
        ItemStack stack = ItemUtil.getWrittenBook((String)"book.aroma1997sdimension:name", (String)"SkyeFirez", (boolean)true, (String[])list.toArray(new String[list.size()]));
        stack.func_77978_p().func_74778_a("id", "DimensionalWorld");
        return stack;
    }

    public static String getWorldMessage() {
        if (!Config.instance.enableMessage || Config.instance.sendMessage == null) {
            return null;
        }
        String msg = Colors.applyColors((String)Config.instance.sendMessage);
        return msg;
    }

    static {
        creativeTabDW = new AromicCreativeTab("aroma1997sdimension".toLowerCase() + ":creativeTabDW", () -> new ItemStack((Item)DimensionalWorldItems.portalIgniter));
    }
}

