/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class JSonTools {
    public static int get(JsonObject object, String name, int def) {
        if (object.has(name)) {
            return object.get(name).getAsInt();
        }
        return def;
    }

    public static boolean get(JsonObject object, String name, boolean def) {
        if (object.has(name)) {
            return object.get(name).getAsBoolean();
        }
        return def;
    }

    public static String get(JsonObject object, String name, String def) {
        if (object.has(name)) {
            return object.get(name).getAsString();
        }
        return def;
    }

    public static void put(JsonObject object, String name, Integer value, Integer def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive((Number)value));
    }

    public static void put(JsonObject object, String name, Boolean value, Boolean def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive(value));
    }

    public static void put(JsonObject object, String name, String value, String def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive(value));
    }

    public static void putStringList(JsonObject object, String name, @Nullable List<String> list) {
        if (list == null) {
            return;
        }
        if (list.size() == 1) {
            object.add(name, (JsonElement)new JsonPrimitive(list.get(0)));
        } else {
            JsonArray array = new JsonArray();
            for (String s : list) {
                array.add((JsonElement)new JsonPrimitive(s));
            }
            object.add(name, (JsonElement)array);
        }
    }

    @Nullable
    public static List<String> getStringList(JsonObject object, String name) {
        if (!object.has(name)) {
            return null;
        }
        if (object.get(name).isJsonArray()) {
            JsonArray array = object.getAsJsonArray(name);
            ArrayList<String> result = new ArrayList<String>();
            for (JsonElement element : array) {
                result.add(element.getAsString());
            }
            return result;
        }
        return Collections.singletonList(object.get(name).getAsString());
    }
}

