/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ColorChoiceEvent;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractLabel;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypeConvertors;
import mcjty.lib.typed.TypedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class ColorSelector
extends AbstractLabel<ColorSelector> {
    public static final String TYPE_COLORSELECTOR = "colorselector";
    public static final Key<Integer> PARAM_COLOR = new Key<Integer>("color", Type.INTEGER);
    private Integer currentColor = null;
    private List<ColorChoiceEvent> choiceEvents = null;

    public ColorSelector(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setText("");
    }

    public ColorSelector setCurrentColor(Integer color) {
        this.currentColor = color;
        return this;
    }

    public Integer getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void draw(int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabled()) {
            Integer color = this.getCurrentColorSafe();
            this.drawStyledBoxNormal(this.window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, 0xFF000000 | color);
            RenderHelper.drawLeftTriangle(xx + this.bounds.width - 10, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleNormal);
            RenderHelper.drawRightTriangle(xx + this.bounds.width - 4, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleNormal);
        } else {
            this.drawStyledBoxDisabled(this.window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            RenderHelper.drawLeftTriangle(xx + this.bounds.width - 10, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleDisabled);
            RenderHelper.drawRightTriangle(xx + this.bounds.width - 4, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleDisabled);
        }
        super.drawOffset(x, y, 0, 1);
    }

    private Integer getCurrentColorSafe() {
        Integer color = this.getCurrentColor();
        if (color == null) {
            color = 0;
        }
        return color;
    }

    @Override
    public Widget<?> mouseClick(int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            this.createColorSelectorWindow(this.window, x, y);
        }
        return null;
    }

    private static int parseIntSafe(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void setSelectedColor(TextField red, TextField green, TextField blue, Button current, int color) {
        red.setText(String.valueOf(color >> 16 & 0xFF));
        green.setText(String.valueOf(color >> 8 & 0xFF));
        blue.setText(String.valueOf(color & 0xFF));
        current.setColor(this.calculateContrastingColor(color));
        current.setFilledBackground(0xFF000000 | color);
    }

    private int getInputColor(TextField red, TextField green, TextField blue) {
        int r = ColorSelector.parseIntSafe(red.getText());
        int g = ColorSelector.parseIntSafe(green.getText());
        int b = ColorSelector.parseIntSafe(blue.getText());
        return (r << 16) + (g << 8) + b;
    }

    private int calculateContrastingColor(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = red + 128 & 0xFF;
        green = green + 128 & 0xFF;
        blue = blue + 128 & 0xFF;
        return (red << 16) + (green << 8) + blue;
    }

    private void createColorSelectorWindow(Window window, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = window.getWindowManager().getGui();
        Panel modalDialog = ((Panel)new Panel(mc, (Gui)gui).setFilledRectThickness(2)).setLayout(new PositionalLayout());
        int wx = (int)(window.getToplevel().getBounds().getX() + 20.0);
        int wy = (int)(window.getToplevel().getBounds().getY() + 20.0);
        modalDialog.setBounds(new Rectangle(wx, wy, 240, 160));
        int cc = this.getCurrentColorSafe();
        Button current = (Button)((Button)((Button)((Button)new Button(mc, (Gui)gui).setLayoutHint(new PositionalLayout.PositionalHint(5, 108, 95, 27))).setText("Current")).setColor(this.calculateContrastingColor(cc))).setFilledBackground(0xFF000000 | cc);
        TextField red = (TextField)new TextField(mc, (Gui)gui).setLayoutHint(new PositionalLayout.PositionalHint(5, 5, 30, 15));
        TextField green = (TextField)new TextField(mc, (Gui)gui).setLayoutHint(new PositionalLayout.PositionalHint(38, 5, 30, 15));
        TextField blue = (TextField)new TextField(mc, (Gui)gui).setLayoutHint(new PositionalLayout.PositionalHint(71, 5, 30, 15));
        this.setSelectedColor(red, green, blue, current, cc);
        red.addTextEnterEvent((parent, newText) -> {
            this.currentColor = this.getInputColor(red, green, blue);
            current.setColor(this.calculateContrastingColor(this.currentColor));
            current.setFilledBackground(0xFF000000 | this.currentColor);
            this.fireChoiceEvents(this.currentColor);
        });
        green.addTextEnterEvent((parent, newText) -> {
            this.currentColor = this.getInputColor(red, green, blue);
            current.setColor(this.calculateContrastingColor(this.currentColor));
            current.setFilledBackground(0xFF000000 | this.currentColor);
            this.fireChoiceEvents(this.currentColor);
        });
        blue.addTextEnterEvent((parent, newText) -> {
            this.currentColor = this.getInputColor(red, green, blue);
            current.setColor(this.calculateContrastingColor(this.currentColor));
            current.setFilledBackground(0xFF000000 | this.currentColor);
            this.fireChoiceEvents(this.currentColor);
        });
        for (EnumDyeColor color2 : EnumDyeColor.values()) {
            int i = color2.ordinal();
            int xx = i % 4;
            int yy = i / 4;
            Button colorLabel = (Button)((Button)((Button)((Button)new Button(mc, (Gui)gui).setColor(color2.func_193350_e())).setTooltips(new String[]{color2.func_192396_c()})).setFilledBackground(0xFF000000 | color2.func_193350_e())).addButtonEvent(parent -> {
                this.currentColor = color2.func_193350_e() & 0xFFFFFF;
                this.setSelectedColor(red, green, blue, current, this.currentColor);
                this.fireChoiceEvents(this.currentColor);
            }).setLayoutHint(new PositionalLayout.PositionalHint(5 + xx * 20, 23 + yy * 20, 18, 18));
            modalDialog.addChild(colorLabel);
        }
        ImageLabel colors = (ImageLabel)((ImageLabel)((ImageLabel)new ImageLabel(mc, (Gui)gui).setImage(new ResourceLocation("mcjtylib_ng", "textures/gui/colorpicker.png"), 0, 0)).setTextureDimensions(128, 128)).setLayoutHint(new PositionalLayout.PositionalHint(105, 5, 128, 128));
        Button close = (Button)((Button)new Button(mc, (Gui)gui).setLayoutHint(new PositionalLayout.PositionalHint(90, 140, 60, 15))).setText("Close");
        modalDialog.addChildren(close, colors, red, green, blue, current);
        Window modalWindow = window.getWindowManager().createModalWindow(modalDialog);
        colors.addImageEvent((parent, u, v, color) -> {
            this.currentColor = color & 0xFFFFFF;
            this.setSelectedColor(red, green, blue, current, this.currentColor);
            this.fireChoiceEvents(this.currentColor);
        });
        close.addButtonEvent(parent -> window.getWindowManager().closeWindow(modalWindow));
    }

    public ColorSelector addChoiceEvent(ColorChoiceEvent event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ColorChoiceEvent>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ColorChoiceEvent event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(Integer color) {
        this.fireChannelEvents(TypedMap.builder().put(Window.PARAM_ID, "choice").put(PARAM_COLOR, color).build());
        if (this.choiceEvents != null) {
            for (ColorChoiceEvent event : this.choiceEvents) {
                event.choiceChanged(this, color);
            }
        }
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        command.removeParameter(1);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_COLORSELECTOR);
    }

    @Override
    public <T> void setGenericValue(T value) {
        this.setCurrentColor(TypeConvertors.toInt(value));
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        return this.getCurrentColor();
    }
}

