/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.MapKeys;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkProfiler
implements Runnable {
    private final World world;
    private final ProfilingTimer timer;
    private final List<Chunk> chunks;
    @Nonnull
    private final ProfiledDimensionData dimensionData;
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_HEIGHT = 256;

    public ChunkProfiler(World world, List<Chunk> chunks, @Nonnull ProfiledDimensionData dimensionData, ProfilingTimer timer) {
        this.world = world;
        this.chunks = chunks;
        this.dimensionData = dimensionData;
        this.timer = timer;
    }

    @Override
    public void run() {
        this.chunks.forEach(this::profileChunk);
    }

    private void profileChunk(Chunk chunk) {
        int dimId = this.world.field_73011_w.func_186058_p().func_186068_a();
        this.timer.startChunk(dimId);
        HashMap<String, Object[]> temp = new HashMap<String, Object[]>();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        RayTraceResult rayTraceResult = new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.DOWN, (BlockPos)blockPos);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int maxY = chunk.func_76625_h();
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Object[] array;
                    blockPos.func_181079_c(x + chunk.field_76635_g * 16, y, z + chunk.field_76647_h * 16);
                    IBlockState blockState = chunk.func_186032_a(x, y, z);
                    String key = MapKeys.getKey(blockState, rayTraceResult, this.world, (BlockPos)blockPos, (EntityPlayer)player);
                    if (!this.dimensionData.dropsMap.containsKey(key)) {
                        this.dimensionData.dropsMap.put(key, ChunkProfiler.getDrops((IBlockAccess)this.world, (BlockPos)blockPos, blockState));
                    }
                    if (!this.dimensionData.silkTouchMap.containsKey(key)) {
                        Block block = blockState.func_177230_c();
                        boolean canSilkTouch = block.canSilkHarvest(this.world, (BlockPos)blockPos, blockState, (EntityPlayer)player);
                        this.dimensionData.silkTouchMap.put(key, canSilkTouch);
                    }
                    if ((array = (Integer[])temp.get(key)) == null) {
                        array = new Integer[256];
                        Arrays.fill(array, (Object)0);
                    }
                    Object[] objectArray = array;
                    int n = y;
                    Object object = objectArray[n];
                    objectArray[n] = (Integer)objectArray[n] + 1;
                    Integer n2 = objectArray[n];
                    temp.put(key, array);
                }
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            Object[] array = (Integer[])this.dimensionData.distributionMap.get(entry.getKey());
            if (array == null) {
                array = new Integer[256];
                Arrays.fill(array, (Object)0);
            }
            for (int i = 0; i < 256; ++i) {
                Object[] objectArray = array;
                int n = i;
                Integer.valueOf((Integer)objectArray[n] + ((Integer[])entry.getValue())[i]);
            }
            this.dimensionData.distributionMap.put((String)entry.getKey(), (Integer[])array);
        }
        this.timer.endChunk(dimId);
    }

    public static Map<String, Map<Integer, Float>> getDrops(IBlockAccess world, BlockPos pos, IBlockState state) {
        int totalTries = 10000;
        Block block = state.func_177230_c();
        HashMap<String, Map<Integer, Float>> resultMap = new HashMap<String, Map<Integer, Float>>();
        for (int fortune = 0; fortune <= 3; ++fortune) {
            HashMap<String, Integer> dropsMap = new HashMap<String, Integer>();
            for (int i = 0; i < 10000; ++i) {
                List drops = block.getDrops(world, pos, state, fortune);
                for (ItemStack drop : drops) {
                    if (drop == null) continue;
                    String key = MapKeys.getKey(drop);
                    Integer count = (Integer)dropsMap.get(key);
                    count = count != null ? Integer.valueOf(count + drop.func_190916_E()) : Integer.valueOf(drop.func_190916_E());
                    dropsMap.put(key, count);
                }
            }
            for (Map.Entry dropEntry : dropsMap.entrySet()) {
                HashMap<Integer, Float> fortuneMap = (HashMap<Integer, Float>)resultMap.get(dropEntry.getKey());
                if (fortuneMap == null) {
                    fortuneMap = new HashMap<Integer, Float>();
                }
                fortuneMap.put(fortune, Float.valueOf((float)((Integer)dropEntry.getValue()).intValue() / 10000.0f));
                resultMap.put((String)dropEntry.getKey(), (Map<Integer, Float>)fortuneMap);
            }
        }
        return resultMap;
    }
}

