/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class DungeonWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    public final DungeonEntry chest;
    private boolean done;
    private int lidStart;

    public DungeonWrapper(DungeonEntry chest) {
        this.chest = chest;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setOutputs(ItemStack.class, this.chest.getItemStacks(null));
    }

    public int amountOfItems(IFocus<ItemStack> focus) {
        return this.chest.getItemStacks(focus).size();
    }

    public List<ItemStack> getItems(IFocus<ItemStack> focus, int slot, int slots) {
        List<ItemStack> list = this.chest.getItemStacks(focus).subList(slot, slot + 1);
        for (int n = 1; n < this.amountOfItems(focus) / slots + 1; ++n) {
            list.add(this.amountOfItems(focus) <= slot + slots * n ? null : this.chest.getItemStacks(focus).get(slot + slots * n));
        }
        list.removeIf(Objects::isNull);
        return list;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        RenderHelper.renderChest(15.0f, 20.0f, -40.0f, 20.0f, this.getLidAngle());
        Font.normal.print(TranslationHelper.translateToLocal(this.chest.getName()), 60, 7);
        Font.small.print(DungeonRegistry.getInstance().getNumStacks(this.chest), 60, 20);
    }

    public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
        tooltip.add(this.chest.getChestDrop(ingredient).toString());
    }

    private float getLidAngle() {
        float angle = ((int)System.currentTimeMillis() / 100 - this.lidStart) % 80;
        if (angle > 50.0f || this.done) {
            this.done = true;
            angle = 50.0f;
        }
        return angle;
    }

    public void resetLid() {
        this.lidStart = (int)System.currentTimeMillis() / 100;
    }
}

