/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.util.LootTableHelper;
import jeresources.util.MobHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootTable;

public class MobEntry {
    private EntityLivingBase entity;
    private Set<LootDrop> drops;
    private LightLevel lightLevel;
    private List<String> biomes;
    private int minExp;
    private int maxExp;

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, int minExp, int maxExp, String[] biomes, LootDrop ... drops) {
        this.entity = entity;
        this.lightLevel = lightLevel;
        this.biomes = new ArrayList<String>();
        this.biomes.addAll(Arrays.asList(biomes));
        this.drops = new TreeSet<LootDrop>();
        this.drops.addAll(Arrays.asList(drops));
        this.maxExp = maxExp;
        this.minExp = minExp;
    }

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, String[] biomes, LootDrop ... drops) {
        this(entity, lightLevel, 0, 0, biomes, drops);
        this.maxExp = this.minExp = MobHelper.getExpDrop(this);
    }

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, int exp, String[] biomes, LootDrop ... drops) {
        this(entity, lightLevel, exp, exp, biomes, drops);
    }

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, int exp, LootDrop ... drops) {
        this(entity, lightLevel, exp, exp, drops);
    }

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, int minExp, int maxExp, LootDrop ... drops) {
        this.entity = entity;
        this.lightLevel = lightLevel;
        this.biomes = new ArrayList<String>();
        this.biomes.add("Any");
        this.drops = new TreeSet<LootDrop>();
        this.drops.addAll(Arrays.asList(drops));
        this.maxExp = maxExp;
        this.minExp = minExp;
    }

    public MobEntry(EntityLivingBase entity, LightLevel lightLevel, LootDrop ... drops) {
        this(entity, lightLevel, 0, 0, drops);
        this.maxExp = this.minExp = MobHelper.getExpDrop(this);
    }

    public MobEntry(EntityLivingBase entity, LootDrop ... drops) {
        this(entity, LightLevel.any, drops);
    }

    public MobEntry(EntityLivingBase entity, LootTable lootTable) {
        this(entity, LightLevel.any, new LootDrop[0]);
        this.drops.addAll(LootTableHelper.toDrops(lootTable));
    }

    public MobEntry(EntityLivingBase entity) {
        this(entity, LightLevel.any, new LootDrop[0]);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public String getMobName() {
        return MobHelper.getExpandedName(this);
    }

    public LootDrop[] getDrops() {
        return this.drops.toArray(new LootDrop[this.drops.size()]);
    }

    public List<ItemStack> getDropsItemStacks() {
        return this.drops.stream().map(LootDrop::getDrops).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String[] getBiomes() {
        return this.biomes.toArray(new String[this.biomes.size()]);
    }

    public boolean addDrop(LootDrop item) {
        for (LootDrop drop : this.drops) {
            if (!drop.item.func_77969_a(item.item)) continue;
            return false;
        }
        this.drops.add(item);
        return true;
    }

    public void addDrops(LootDrop ... drops) {
        for (LootDrop drop : drops) {
            this.addDrop(drop);
        }
    }

    public void addDrops(Collection<LootDrop> drops) {
        drops.stream().filter(Objects::nonNull).forEach(this::addDrop);
    }

    public LightLevel getLightLevel() {
        return this.lightLevel;
    }

    public String getExp() {
        return this.minExp + (this.maxExp == this.minExp ? "" : " - " + this.maxExp);
    }
}

