/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class AutomaticRecipeUnlock
extends Feature {
    List<String> ignored;
    boolean forceLimitedCrafting;
    boolean disableRecipeBook;

    @Override
    public void setupConfig() {
        String[] ignoredArr = this.loadPropStringList("Ignored Recipes", "A list of recipe names that should NOT be added in by default", new String[0]);
        this.ignored = Arrays.asList(ignoredArr);
        this.forceLimitedCrafting = this.loadPropBool("Force Limited Crafting", "Set to true to force the doLimitedCrafting gamerule to true.\nCombine this with the Ignored Recipes list to create a system where only a few selected recipes are locked.", false);
        this.disableRecipeBook = this.loadPropBool("Disable Recipe Book", "Set this to true to disable the vanilla recipe book altogether.", false);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ArrayList recipes = Lists.newArrayList((Iterable)CraftingManager.field_193380_a);
            recipes.removeIf(recipe -> this.ignored.contains(recipe.getRegistryName().toString()) || recipe.func_77571_b().func_190926_b());
            ((EntityPlayerMP)event.player).func_192021_a((List)recipes);
            if (this.forceLimitedCrafting) {
                event.player.field_70170_p.func_82736_K().func_82764_b("doLimitedCrafting", "true");
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (this.disableRecipeBook && (gui instanceof GuiInventory || gui instanceof GuiCrafting)) {
            Minecraft.func_71410_x().field_71439_g.func_192035_E().func_192813_a(false);
            event.getButtonList().removeIf(b -> b.field_146127_k == 10);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

