/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageTuneNoteBlock;
import vazkii.quark.misc.feature.NoteBlockInterface;
import vazkii.quark.misc.feature.NoteBlocksMobSounds;

public class GuiNoteBlock
extends GuiScreen {
    private static final SoundEvent[] INSTRUMENTS = new SoundEvent[]{SoundEvents.field_187682_dG, SoundEvents.field_187676_dE, SoundEvents.field_187688_dI, SoundEvents.field_187685_dH, SoundEvents.field_187679_dF};
    private static ResourceLocation noteblockResource = new ResourceLocation("quark", "textures/misc/noteblock.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final String[] KEY_NAMES = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};
    private static final int[] KEY_BINDS_QWERTY = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 30, 31, 32, 33, 34, 35, 36, 37, 38, 44, 45, 46, 47, 48, 49, 50};
    private static final int[] KEY_BINDS_AZERTY = new int[]{30, 44, 18, 19, 20, 21, 22, 23, 24, 25, 16, 31, 32, 33, 34, 35, 36, 37, 38, 50, 17, 45, 46, 47, 48};
    private static final int[] KEY_BINDS_DVORAK = new int[]{25, 21, 33, 34, 46, 19, 38, 24, 18, 22, 23, 32, 35, 20, 49, 31, 16, 36, 37, 45, 48, 50, 17, 47, 44};
    private List<Key> whiteKeys = new ArrayList<Key>();
    private List<Key> blackKeys = new ArrayList<Key>();
    Key hoveredKey = null;
    boolean hoversNoteBlock = false;
    TileEntityNote noteBlock;
    CoordinateHolder coords = new CoordinateHolder();

    public GuiNoteBlock(TileEntityNote noteBlock) {
        this.noteBlock = noteBlock;
    }

    public void func_73866_w_() {
        this.whiteKeys.clear();
        this.blackKeys.clear();
        this.blackKeys.add(new BlackKey(0, 0));
        this.blackKeys.add(new BlackKey(1, 2));
        this.blackKeys.add(new BlackKey(2, 4));
        this.blackKeys.add(new BlackKey(4, 7));
        this.blackKeys.add(new BlackKey(5, 9));
        this.blackKeys.add(new BlackKey(7, 12));
        this.blackKeys.add(new BlackKey(8, 14));
        this.blackKeys.add(new BlackKey(9, 16));
        this.blackKeys.add(new BlackKey(11, 19));
        this.blackKeys.add(new BlackKey(12, 21));
        this.blackKeys.add(new BlackKey(14, 24));
        this.whiteKeys.add(new WhiteKey(0, 1, 1));
        this.whiteKeys.add(new WhiteKey(1, 3, 1));
        this.whiteKeys.add(new WhiteKey(2, 5, 2));
        this.whiteKeys.add(new WhiteKey(3, 6, 0));
        this.whiteKeys.add(new WhiteKey(4, 8, 1));
        this.whiteKeys.add(new WhiteKey(5, 10, 2));
        this.whiteKeys.add(new WhiteKey(6, 11, 0));
        this.whiteKeys.add(new WhiteKey(7, 13, 1));
        this.whiteKeys.add(new WhiteKey(8, 15, 1));
        this.whiteKeys.add(new WhiteKey(9, 17, 2));
        this.whiteKeys.add(new WhiteKey(10, 18, 0));
        this.whiteKeys.add(new WhiteKey(11, 20, 1));
        this.whiteKeys.add(new WhiteKey(12, 22, 2));
        this.whiteKeys.add(new WhiteKey(13, 23, 0));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.noteBlock == null || this.noteBlock.func_145831_w().func_175625_s(this.noteBlock.func_174877_v()) != this.noteBlock) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        int panelWidth = 320;
        int panelHeight = 102;
        int left = this.field_146294_l / 2 - panelWidth / 2;
        int top = this.field_146295_m / 2 - panelHeight / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)left, (float)top, (float)0.0f);
        this.field_146297_k.field_71446_o.func_110577_a(noteblockResource);
        GuiNoteBlock.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)panelWidth, (int)panelHeight, (float)512.0f, (float)256.0f);
        this.coords.baseX = 46;
        this.coords.baseY = 8;
        this.coords.mouseX = mouseX - left;
        this.coords.mouseY = mouseY - top;
        this.hoveredKey = null;
        this.hoversNoteBlock = this.coords.mouseX >= 9 && this.coords.mouseX < 40 && this.coords.mouseY >= 9 && this.coords.mouseY < 40;
        for (Key k : this.blackKeys) {
            this.field_146297_k.field_71446_o.func_110577_a(noteblockResource);
            if (!k.renderKey(this.field_146297_k, true, this.coords)) continue;
            this.hoveredKey = k;
        }
        this.coords.baseX += 7;
        for (Key k : this.whiteKeys) {
            this.field_146297_k.field_71446_o.func_110577_a(noteblockResource);
            if (!k.renderKey(this.field_146297_k, this.hoveredKey == null, this.coords)) continue;
            this.hoveredKey = k;
        }
        this.field_146297_k.field_71446_o.func_110577_a(noteblockResource);
        float scale = 2.0f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        ItemStack head = this.getHead();
        if (!head.func_190926_b()) {
            RenderHelper.func_74520_c();
            this.field_146297_k.func_175599_af().func_180450_b(head, 4, 30);
        } else {
            GuiNoteBlock.func_146110_a((int)4, (int)30, (float)(this.getNote() * 16), (float)panelHeight, (int)16, (int)16, (float)512.0f, (float)256.0f);
        }
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        scale = 1.8f;
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)9.0f, (float)9.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.field_146297_k.func_175599_af().func_180450_b(new ItemStack(Blocks.field_150323_B), 0, 0);
        GlStateManager.func_179121_F();
        if (this.hoversNoteBlock) {
            vazkii.arl.util.RenderHelper.renderTooltip((int)mouseX, (int)mouseY, Arrays.asList(I18n.func_135052_a((String)"quarkmisc.incrementNote", (Object[])new Object[0])));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (this.hoveredKey != null) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageTuneNoteBlock(this.noteBlock, false, this.hoveredKey.clicks));
            } else if (this.hoversNoteBlock) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageTuneNoteBlock(this.noteBlock, true, 0));
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (Key k : this.whiteKeys) {
            this.play(k, keyCode);
        }
        for (Key k : this.blackKeys) {
            this.play(k, keyCode);
        }
    }

    private void play(Key k, int code) {
        int expected = GuiNoteBlock.getKey(k.clicks);
        if (expected == code) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageTuneNoteBlock(this.noteBlock, false, k.clicks));
        }
    }

    private int getNote() {
        IBlockState state = this.noteBlock.func_145831_w().func_180495_p(this.noteBlock.func_174877_v().func_177977_b());
        Material material = state.func_185904_a();
        Block block = state.func_177230_c();
        int note = 0;
        if (material == Material.field_151576_e) {
            note = 1;
        } else if (material == Material.field_151595_p) {
            note = 2;
        } else if (material == Material.field_151592_s) {
            note = 3;
        } else if (material == Material.field_151575_d) {
            note = 4;
        }
        if (block == Blocks.field_150435_aG) {
            note = 5;
        } else if (block == Blocks.field_150340_R) {
            note = 6;
        } else if (block == Blocks.field_150325_L) {
            note = 7;
        } else if (block == Blocks.field_150403_cj) {
            note = 8;
        } else if (block == Blocks.field_189880_di) {
            note = 9;
        }
        return note;
    }

    private ItemStack getHead() {
        if (!ModuleLoader.isFeatureEnabled(NoteBlocksMobSounds.class)) {
            return ItemStack.field_190927_a;
        }
        int type = NoteBlocksMobSounds.getSkullType(this.noteBlock.func_145831_w(), this.noteBlock.func_174877_v());
        if (type != -1 && type != 3) {
            return new ItemStack(Items.field_151144_bL, 1, type);
        }
        return ItemStack.field_190927_a;
    }

    private static int getKey(int index) {
        int[] keys = KEY_BINDS_QWERTY;
        if (NoteBlockInterface.keyboardLayout.equalsIgnoreCase("azerty")) {
            keys = KEY_BINDS_AZERTY;
        } else if (NoteBlockInterface.keyboardLayout.equalsIgnoreCase("dvorak")) {
            keys = KEY_BINDS_DVORAK;
        }
        return keys[index];
    }

    public boolean func_73868_f() {
        return false;
    }

    private static class CoordinateHolder {
        int baseX;
        int baseY;
        int mouseX;
        int mouseY;

        private CoordinateHolder() {
        }
    }

    private static class BlackKey
    extends Key {
        public BlackKey(int position, int clicks) {
            super(position * 18, 0, 14, 45, clicks);
        }

        @Override
        boolean renderKey(Minecraft mc, boolean canHover, CoordinateHolder c) {
            boolean hovered = canHover && this.isHovered(c) || Keyboard.isKeyDown((int)GuiNoteBlock.getKey(this.clicks));
            int u = 374;
            int v = hovered ? this.h : 0;
            Gui.func_146110_a((int)(c.baseX + this.x), (int)(c.baseY + this.y), (float)u, (float)v, (int)this.w, (int)this.h, (float)512.0f, (float)256.0f);
            if (hovered) {
                this.renderNote(mc, c);
            }
            return hovered;
        }
    }

    private static class WhiteKey
    extends Key {
        private final int type;

        public WhiteKey(int position, int clicks, int type) {
            super(position * 18, 0, 18, 86, clicks);
            this.type = type;
        }

        @Override
        boolean renderKey(Minecraft mc, boolean canHover, CoordinateHolder c) {
            boolean hovered = canHover && this.isHovered(c) || Keyboard.isKeyDown((int)GuiNoteBlock.getKey(this.clicks));
            int u = 320 + this.w * this.type;
            int v = hovered ? this.h : 0;
            Gui.func_146110_a((int)(c.baseX + this.x), (int)(c.baseY + this.y), (float)u, (float)v, (int)this.w, (int)this.h, (float)512.0f, (float)256.0f);
            if (hovered) {
                this.renderNote(mc, c);
            }
            return hovered;
        }
    }

    private static abstract class Key {
        public final int x;
        public final int y;
        public final int w;
        public final int h;
        public final byte clicks;
        public final String desc;

        public Key(int x, int y, int w, int h, int clicks) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.clicks = (byte)clicks;
            this.desc = KEY_NAMES[clicks];
        }

        final boolean isHovered(CoordinateHolder c) {
            int x = c.baseX + this.x;
            int y = c.baseY + this.y;
            return c.mouseX >= x && c.mouseY >= y && c.mouseX < x + this.w && c.mouseY < y + this.h;
        }

        final void renderNote(Minecraft mc, CoordinateHolder c) {
            int x = c.baseX + this.x;
            int y = c.baseY + this.y;
            int sw = mc.field_71466_p.func_78256_a(this.desc);
            int color = Color.HSBtoRGB((float)(24 - this.clicks) / 24.0f - 0.6f, 1.0f, 1.0f);
            mc.field_71466_p.func_78276_b(this.desc, x + this.w / 2 - sw / 2, y + this.h - 24, color);
            String s = Integer.toString(this.clicks);
            sw = mc.field_71466_p.func_78256_a(s);
            mc.field_71466_p.func_78276_b(s, x + this.w / 2 - sw / 2, y + this.h - 13, this instanceof BlackKey ? 0xCCCCCC : 0x333333);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }

        abstract boolean renderKey(Minecraft var1, boolean var2, CoordinateHolder var3);
    }
}

