/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.Feature;

public class AutomaticToolRestock
extends Feature {
    private static final WeakHashMap<EntityPlayer, Stack<Pair<Integer, Integer>>> replacements = new WeakHashMap();
    public List<Enchantment> importantEnchants = new ArrayList<Enchantment>();
    private String[] enchantNames;
    private boolean enableLooseMatching;
    private boolean enableEnchantMatching;
    private boolean unstackablesOnly;

    @Override
    public void setupConfig() {
        this.enchantNames = this.loadPropStringList("Important Enchantments", "Enchantments deemed important enough to have special priority when finding a replacement", this.generateDefaultEnchantmentList());
        this.enableLooseMatching = this.loadPropBool("Enable Loose Matching", "Enable replacing your tools with tools of the same type but not the same item", true);
        this.enableEnchantMatching = this.loadPropBool("Enable Enchantment Matching", "Enable comparing enchantments to find a replacement", true);
        this.unstackablesOnly = this.loadPropBool("Unstackable Items Only", "", false);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.importantEnchants.clear();
        for (String s : this.enchantNames) {
            ResourceLocation r = new ResourceLocation(s);
            Enchantment e = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)r);
            if (e == null) continue;
            this.importantEnchants.add(e);
        }
    }

    @SubscribeEvent
    public void onToolBreak(PlayerDestroyItemEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOriginal();
        Item item = stack.func_77973_b();
        if (!(player == null || player.field_70170_p == null || player.field_70170_p.field_72995_K || stack.func_190926_b() || item instanceof ItemArmor || this.unstackablesOnly && stack.func_77985_e())) {
            Set<String> classes;
            int currSlot = player.field_71071_by.field_70461_c;
            if (event.getHand() == EnumHand.OFF_HAND) {
                currSlot = player.field_71071_by.func_70302_i_() - 1;
            }
            List<Enchantment> enchantmentsOnStack = this.getImportantEnchantments(stack);
            Predicate<ItemStack> itemPredicate = other -> other.func_77973_b() == item;
            if (!stack.func_77984_f()) {
                itemPredicate = itemPredicate.and(other -> other.func_77952_i() == stack.func_77952_i());
            }
            Predicate<ItemStack> enchantmentPredicate = other -> !new ArrayList(enchantmentsOnStack).retainAll(this.getImportantEnchantments((ItemStack)other));
            if (this.enableEnchantMatching && this.findReplacement(player, currSlot, itemPredicate.and(enchantmentPredicate))) {
                return;
            }
            if (this.findReplacement(player, currSlot, itemPredicate)) {
                return;
            }
            if (this.enableLooseMatching && !(classes = this.getItemClasses(stack)).isEmpty()) {
                Predicate<ItemStack> toolPredicate = other -> {
                    Set<String> otherClasses = this.getItemClasses((ItemStack)other);
                    return !otherClasses.isEmpty() && !otherClasses.retainAll(classes);
                };
                if (this.enableEnchantMatching && !enchantmentsOnStack.isEmpty() && this.findReplacement(player, currSlot, toolPredicate.and(enchantmentPredicate))) {
                    return;
                }
                this.findReplacement(player, currSlot, toolPredicate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && replacements.containsKey(event.player)) {
            Stack<Pair<Integer, Integer>> replacementStack = replacements.get(event.player);
            AutomaticToolRestock automaticToolRestock = this;
            synchronized (automaticToolRestock) {
                while (!replacementStack.isEmpty()) {
                    Pair<Integer, Integer> pair = replacementStack.pop();
                    this.switchItems(event.player, (Integer)pair.getLeft(), (Integer)pair.getRight());
                }
            }
        }
    }

    private Set<String> getItemClasses(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemTool) {
            return new HashSet<String>(((ItemTool)item).getToolClasses(stack));
        }
        if (item instanceof ItemSword) {
            return new HashSet<String>(Arrays.asList("sword"));
        }
        if (item instanceof ItemBow) {
            return new HashSet<String>(Arrays.asList("bow"));
        }
        if (item instanceof ItemFishingRod) {
            return new HashSet<String>(Arrays.asList("fishing_rod"));
        }
        return new HashSet<String>();
    }

    private boolean findReplacement(EntityPlayer player, int currSlot, Predicate<ItemStack> match) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stackAt;
            if (i == currSlot || (stackAt = player.field_71071_by.func_70301_a(i)).func_190926_b() || !match.test(stackAt)) continue;
            this.pushReplace(player, i, currSlot);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushReplace(EntityPlayer player, int slot1, int slot2) {
        AutomaticToolRestock automaticToolRestock = this;
        synchronized (automaticToolRestock) {
            if (!replacements.containsKey(player)) {
                replacements.put(player, new Stack());
            }
            replacements.get(player).push((Pair<Integer, Integer>)Pair.of((Object)slot1, (Object)slot2));
        }
    }

    private void switchItems(EntityPlayer player, int slot1, int slot2) {
        int size = player.field_71071_by.field_70462_a.size();
        if (slot1 >= size || slot2 >= size) {
            return;
        }
        ItemStack stackAtSlot1 = player.field_71071_by.func_70301_a(slot1);
        ItemStack stackAtSlot2 = player.field_71071_by.func_70301_a(slot2);
        player.field_71071_by.func_70299_a(slot2, stackAtSlot1);
        player.field_71071_by.func_70299_a(slot1, stackAtSlot2);
    }

    private List<Enchantment> getImportantEnchantments(ItemStack stack) {
        ArrayList<Enchantment> enchantsOnStack = new ArrayList<Enchantment>();
        for (Enchantment ench : this.importantEnchants) {
            if (EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) <= 0) continue;
            enchantsOnStack.add(ench);
        }
        return enchantsOnStack;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"inventorytweaks"};
    }

    private String[] generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.field_185306_r, Enchantments.field_185308_t, Enchantments.field_185312_x, Enchantments.field_151370_z, Enchantments.field_185304_p};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            if (e == null || e.getRegistryName() == null) continue;
            strings.add(e.getRegistryName().toString());
        }
        return strings.toArray(new String[strings.size()]);
    }
}

