/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.automation.QuarkAutomation;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.QuarkBuilding;
import vazkii.quark.client.QuarkClient;
import vazkii.quark.decoration.QuarkDecoration;
import vazkii.quark.experimental.QuarkExperimental;
import vazkii.quark.management.QuarkManagement;
import vazkii.quark.misc.QuarkMisc;
import vazkii.quark.tweaks.QuarkTweaks;
import vazkii.quark.vanity.QuarkVanity;
import vazkii.quark.world.QuarkWorld;

public final class ModuleLoader {
    public static final boolean DEBUG_MODE;
    private static List<Class<? extends Module>> moduleClasses;
    public static Map<Class<? extends Module>, Module> moduleInstances;
    public static Map<Class<? extends Feature>, Feature> featureInstances;
    public static Map<String, Feature> featureClassnames;
    public static List<Module> enabledModules;
    public static Configuration config;
    public static File configFile;
    public static boolean firstLoad;

    public static void preInit(FMLPreInitializationEvent event) {
        moduleClasses.forEach(clazz -> {
            try {
                moduleInstances.put((Class<? extends Module>)clazz, (Module)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Can't initialize module " + clazz, e);
            }
        });
        ModuleLoader.setupConfig(event);
        ModuleLoader.forEachModule(module -> FMLLog.info((String)("[Quark] Module " + module.name + " is " + (module.enabled ? "enabled" : "disabled")), (Object[])new Object[0]));
        ModuleLoader.forEachEnabled(module -> module.preInit(event));
        ModuleLoader.forEachEnabled(module -> module.postPreInit(event));
    }

    public static void init(FMLInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.init(event));
    }

    public static void postInit(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.postInit(event));
    }

    public static void finalInit(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.finalInit(event));
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient(FMLPreInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.preInitClient(event));
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient(FMLInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.initClient(event));
    }

    @SideOnly(value=Side.CLIENT)
    public static void postInitClient(FMLPostInitializationEvent event) {
        ModuleLoader.forEachEnabled(module -> module.postInitClient(event));
    }

    public static void serverStarting(FMLServerStartingEvent event) {
        ModuleLoader.forEachEnabled(module -> module.serverStarting(event));
    }

    public static void setupConfig(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        if (!configFile.exists()) {
            firstLoad = true;
        }
        config = new Configuration(configFile);
        config.load();
        ModuleLoader.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void loadConfig() {
        GlobalConfig.initGlobalConfig();
        ModuleLoader.forEachModule(module -> {
            module.enabled = true;
            if (module.canBeDisabled()) {
                ConfigHelper.needsRestart = true;
                module.enabled = ConfigHelper.loadPropBool(module.name, "_modules", module.getModuleDescription(), module.isEnabledByDefault());
                module.prop = ConfigHelper.lastProp;
            }
        });
        enabledModules = new ArrayList<Module>(moduleInstances.values());
        enabledModules.removeIf(module -> !module.enabled);
        ModuleLoader.loadModuleConfigs();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void loadModuleConfigs() {
        ModuleLoader.forEachModule(module -> module.setupConfig());
    }

    public static boolean isModuleEnabled(Class<? extends Module> clazz) {
        return ModuleLoader.moduleInstances.get(clazz).enabled;
    }

    public static boolean isFeatureEnabled(Class<? extends Feature> clazz) {
        return ModuleLoader.featureInstances.get(clazz).enabled;
    }

    public static void forEachModule(Consumer<Module> consumer) {
        moduleInstances.values().forEach(consumer);
    }

    public static void forEachEnabled(Consumer<Module> consumer) {
        enabledModules.forEach(consumer);
    }

    private static void registerModule(Class<? extends Module> clazz) {
        if (!moduleClasses.contains(clazz)) {
            moduleClasses.add(clazz);
        }
    }

    static {
        moduleClasses = new ArrayList<Class<? extends Module>>();
        ModuleLoader.registerModule(QuarkTweaks.class);
        ModuleLoader.registerModule(QuarkWorld.class);
        ModuleLoader.registerModule(QuarkVanity.class);
        ModuleLoader.registerModule(QuarkDecoration.class);
        ModuleLoader.registerModule(QuarkBuilding.class);
        ModuleLoader.registerModule(QuarkAutomation.class);
        ModuleLoader.registerModule(QuarkManagement.class);
        ModuleLoader.registerModule(QuarkClient.class);
        ModuleLoader.registerModule(QuarkMisc.class);
        ModuleLoader.registerModule(QuarkExperimental.class);
        DEBUG_MODE = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
        moduleInstances = new HashMap<Class<? extends Module>, Module>();
        featureInstances = new HashMap<Class<? extends Feature>, Feature>();
        featureClassnames = new HashMap<String, Feature>();
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("quark")) {
                ModuleLoader.loadConfig();
            }
        }
    }
}

