/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.world.StoneInfoBasedGenerator;

public final class BiomeTypeConfigHandler {
    public static List<BiomeDictionary.Type> parseBiomeTypeArrayConfig(String name, String category, BiomeDictionary.Type ... biomes) {
        String[] defaultBiomes = (String[])Arrays.stream(biomes).map(b -> b.getName()).toArray(String[]::new);
        String[] readBiomes = ModuleLoader.config.getStringList(name, category, defaultBiomes, "Biome Type List: https://github.com/MinecraftForge/MinecraftForge/blob/1.11.x/src/main/java/net/minecraftforge/common/BiomeDictionary.java#L44-L90\nTypes per Biome: https://github.com/MinecraftForge/MinecraftForge/blob/1.11.x/src/main/java/net/minecraftforge/common/BiomeDictionary.java#L402-L463");
        return Arrays.stream(readBiomes).map(s -> BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
    }

    public static boolean biomeTypeIntersectCheck(Iterable<BiomeDictionary.Type> biomeItr, Biome b) {
        Set currentTypes = BiomeDictionary.getTypes((Biome)b);
        for (BiomeDictionary.Type type : biomeItr) {
            if (!currentTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    public static void debugStoneGeneration(Iterable<StoneInfoBasedGenerator> generators) {
        System.out.println("### OUTPUTTING BIOME CSV DATA ###");
        System.out.print("sep=;\nBiome");
        for (StoneInfoBasedGenerator gen : generators) {
            System.out.print(";" + WordUtils.capitalize((String)gen.name));
        }
        System.out.print(";Biome Type");
        System.out.println();
        for (ResourceLocation r : Biome.field_185377_q.func_148742_b()) {
            Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)r);
            System.out.print(b.func_185359_l());
            for (StoneInfoBasedGenerator gen : generators) {
                if (gen.canGenerateInBiome(b)) {
                    System.out.print(";yes");
                    continue;
                }
                System.out.print(";no");
            }
            System.out.print(";" + (b.func_185363_b() ? "mutation" : "normal"));
            System.out.println();
        }
        System.out.println("### DONE ###");
    }
}

