/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import vazkii.quark.base.asm.ClassnameMap;
import vazkii.quark.base.asm.LoadingPlugin;

public class ClassTransformer
implements IClassTransformer {
    private static final String ASM_HOOKS = "vazkii/quark/base/asm/ASMHooks";
    public static final ClassnameMap CLASS_MAPPINGS = new ClassnameMap("net/minecraft/entity/Entity", "vg", "net/minecraft/item/ItemStack", "aip", "net/minecraft/client/renderer/block/model/IBakedModel", "cfy", "net/minecraft/entity/EntityLivingBase", "vp", "net/minecraft/inventory/EntityEquipmentSlot", "vl", "net/minecraft/client/renderer/entity/RenderLivingBase", "caa", "net/minecraft/client/model/ModelBase", "bqf", "net/minecraft/util/DamageSource", "ur", "net/minecraft/entity/item/EntityBoat", "afd", "net/minecraft/world/World", "amu", "net/minecraft/util/math/BlockPos", "et", "net/minecraft/util/EnumFacing", "fa", "net/minecraft/entity/player/EntityPlayer", "aed", "net/minecraft/block/state/IBlockState", "awt", "net/minecraft/client/renderer/BufferBuilder", "buk", "net/minecraft/world/IBlockAccess", "amy", "net/minecraft/client/renderer/block/model/BakedQuad", "bvp");
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();
    static int invokestaticCount;
    static int bipushCount;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformModelBiped(byte[] basicClass) {
        ClassTransformer.log("Transforming ModelBiped");
        MethodSignature sig = new MethodSignature("setRotationAngles", "func_78087_a", "a", "(FFFFFFLnet/minecraft/entity/Entity;)V");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> node.getOpcode() == 177, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "updateEmotes", "(Lnet/minecraft/entity/Entity;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformRenderItem(byte[] basicClass) {
        ClassTransformer.log("Transforming RenderItem");
        MethodSignature sig1 = new MethodSignature("renderItem", "func_180454_a", "a", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
        MethodSignature sig2 = new MethodSignature("renderEffect", "func_191966_a", "a", "(Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> true, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setColorRuneTargetStack", "(Lnet/minecraft/item/ItemStack;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)ClassTransformer.combine(node -> node.getOpcode() == 18 && ((LdcInsnNode)node).cst.equals(-8372020), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getRuneColor", "(I)I"));
            method.instructions.insert(node, newInstructions);
            return false;
        })));
        return transClass;
    }

    private static byte[] transformLayerArmorBase(byte[] basicClass) {
        ClassTransformer.log("Transforming LayerArmorBase");
        MethodSignature sig1 = new MethodSignature("renderArmorLayer", "func_188361_a", "a", "(Lnet/minecraft/entity/EntityLivingBase;FFFFFFFLnet/minecraft/inventory/EntityEquipmentSlot;)V");
        MethodSignature sig2 = new MethodSignature("renderEnchantedGlint", "func_188364_a", "a", "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/client/model/ModelBase;FFFFFFF)V");
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> node.getOpcode() == 58, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 10));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setColorRuneTargetStack", "(Lnet/minecraft/item/ItemStack;)V"));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        if (!ClassTransformer.hasOptifine(sig2.toString())) {
            invokestaticCount = 0;
            transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)ClassTransformer.combine(node -> node.getOpcode() == 184 && ((MethodInsnNode)node).desc.equals("(FFFF)V"), (method, node) -> {
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "applyRuneColor", "()V"));
                method.instructions.insert(node, newInstructions);
                return ++invokestaticCount == 2;
            })));
        }
        return transClass;
    }

    private static byte[] transformEntityBoat(byte[] basicClass) {
        ClassTransformer.log("Transforming EntityBoat");
        MethodSignature sig1 = new MethodSignature("attackEntityFrom", "func_70097_a", "a", "(Lnet/minecraft/util/DamageSource;F)Z");
        MethodSignature sig2 = new MethodSignature("onUpdate", "func_70071_h_", "B_", "()V");
        byte[] transClass = ClassTransformer.transform(basicClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> node.getOpcode() == 87, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "dropBoatBanner", "(Lnet/minecraft/entity/item/EntityBoat;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)ClassTransformer.combine(node -> true, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "onBoatUpdate", "(Lnet/minecraft/entity/item/EntityBoat;)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformRenderBoat(byte[] basicClass) {
        ClassTransformer.log("Transforming RenderBoat");
        MethodSignature sig = new MethodSignature("doRender", "func_188300_b", "b", "(Lnet/minecraft/entity/item/EntityBoat;DDDFF)V");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> (node.getOpcode() == 182 || node.getOpcode() == 185) && ClassTransformer.checkDesc(((MethodInsnNode)node).desc, "(Lnet/minecraft/entity/Entity;FFFFFF)V"), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 9));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderBannerOnBoat", "(Lnet/minecraft/entity/item/EntityBoat;F)V"));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformBlockPistonBase(byte[] basicClass) {
        ClassTransformer.log("Transforming BlockPistonBase");
        MethodSignature sig1 = new MethodSignature("doMove", "func_176319_a", "a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)Z");
        MethodSignature sig2 = new MethodSignature("canPush", "func_185646_a", "a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;ZLnet/minecraft/util/EnumFacing;)Z");
        byte[] transClass = ClassTransformer.transform(basicClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> node.getOpcode() == 58 && ((VarInsnNode)node).var == 11, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 8));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 11));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "breakStuffWithSpikes", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/List;Ljava/util/List;Lnet/minecraft/util/EnumFacing;Z)Z"));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "size", "()I"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 8));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "size", "()I"));
            newInstructions.add((AbstractInsnNode)new InsnNode(96));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(54, 9));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 9));
            AbstractInsnNode newNode = node.getPrevious();
            while (true) {
                if (newNode.getOpcode() == 189) break;
                newNode = newNode.getPrevious();
            }
            newInstructions.add((AbstractInsnNode)new TypeInsnNode(189, ((TypeInsnNode)newNode).desc));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(58, 10));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        transClass = ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)ClassTransformer.combine(node -> node.getOpcode() == 182 && ((MethodInsnNode)node).name.equals("hasTileEntity"), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "shouldPistonMoveTE", "(ZLnet/minecraft/block/state/IBlockState;)Z"));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        return transClass;
    }

    private static byte[] transformContainerWorkbench(byte[] basicClass) {
        ClassTransformer.log("Transforming ContainerWorkbench");
        MethodSignature sig = new MethodSignature("transferStackInSlot", "func_82846_b", "b", "(Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;");
        bipushCount = 0;
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> node.getOpcode() == 16, (method, node) -> {
            InsnList newInstructions = new InsnList();
            if (++bipushCount != 5 && bipushCount != 6) {
                return false;
            }
            ClassTransformer.log("Adding invokestatic to " + ((IntInsnNode)node).operand + "/" + bipushCount);
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getInventoryBoundary", "(I)I"));
            method.instructions.insert(node, newInstructions);
            return bipushCount == 6;
        })));
    }

    private static byte[] transformTileEntityPiston(byte[] basicClass) {
        ClassTransformer.log("Transforming TileEntityPiston");
        MethodSignature sig1 = new MethodSignature("clearPistonTileEntity", "func_145866_f", "j", "()V");
        MethodSignature sig2 = new MethodSignature("update", "func_73660_a", "e", "()V");
        MethodAction action = ClassTransformer.combine(node -> node.getOpcode() == 182 && ClassTransformer.checkDesc(((MethodInsnNode)node).desc, "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setPistonBlock", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
            method.instructions.insert(node, newInstructions);
            method.instructions.remove(node);
            return true;
        });
        byte[] transClass = ClassTransformer.transform(basicClass, Pair.of((Object)sig1, (Object)action));
        return ClassTransformer.transform(transClass, Pair.of((Object)sig2, (Object)action));
    }

    private static byte[] transformTileEntityPistonRenderer(byte[] basicClass) {
        ClassTransformer.log("Transforming TileEntityPistonRenderer");
        MethodSignature sig = new MethodSignature("renderStateModel", "func_188186_a", "a", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/world/World;Z)Z");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> true, (method, node) -> {
            InsnList newInstructions = new InsnList();
            for (int i = 1; i <= 4; ++i) {
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, i));
            }
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 5));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderPistonBlock", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/world/World;Z)Z"));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            method.instructions = newInstructions;
            return true;
        })));
    }

    private static byte[] transformWorldServer(byte[] basicClass) {
        ClassTransformer.log("Transforming WorldServer");
        MethodSignature sig = new MethodSignature("areAllPlayersAsleep", "func_73056_e", "g", "()Z");
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig, (Object)ClassTransformer.combine(node -> true, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "isEveryoneAsleep", "(Lnet/minecraft/world/World;)I"));
            newInstructions.add((AbstractInsnNode)new InsnNode(89));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            newInstructions.add((AbstractInsnNode)new InsnNode(4));
            newInstructions.add((AbstractInsnNode)new InsnNode(100));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformBlockModelRenderer(byte[] basicClass) {
        ClassTransformer.log("Transforming BlockModelRenderer");
        MethodSignature sig1 = new MethodSignature("renderQuadsFlat", "func_187496_a", "a", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;IZLnet/minecraft/client/renderer/BufferBuilder;Ljava/util/List;Ljava/util/BitSet;)V");
        if (ClassTransformer.hasOptifine(sig1.toString())) {
            return basicClass;
        }
        return ClassTransformer.transform(basicClass, Pair.of((Object)sig1, (Object)ClassTransformer.combine(node -> node.getOpcode() == 182 && ClassTransformer.checkDesc(((MethodInsnNode)node).desc, "(DDD)V"), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 18));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "putColorsFlat", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/client/renderer/block/model/BakedQuad;I)V"));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transform(byte[] basicClass, Pair<MethodSignature, MethodAction> ... methods) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (Pair<MethodSignature, MethodAction> pair : methods) {
            ClassTransformer.log("Applying Transformation to method (" + pair.getLeft() + ")");
            didAnything |= ClassTransformer.findMethodAndTransform(node, (MethodSignature)pair.getLeft(), (MethodAction)pair.getRight());
        }
        if (didAnything) {
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        String funcName = sig.funcName;
        if (LoadingPlugin.runtimeDeobfEnabled) {
            funcName = sig.srgName;
        }
        for (MethodNode method : node.methods) {
            if (!method.name.equals(funcName) && !method.name.equals(sig.obfName) && !method.name.equals(sig.srgName) || !method.desc.equals(sig.funcDesc) && !method.desc.equals(sig.obfDesc)) continue;
            ClassTransformer.log("Located Method, patching...");
            boolean finish = pred.test(method);
            ClassTransformer.log("Patch result: " + finish);
            return finish;
        }
        ClassTransformer.log("Failed to locate the method!");
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return mnode -> ClassTransformer.applyOnNode(mnode, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            ClassTransformer.log("Located patch target node " + ClassTransformer.getNodeString(anode));
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    private static void log(String str) {
        FMLLog.info((String)"[Quark ASM] %s", (Object[])new Object[]{str});
    }

    private static void prettyPrint(AbstractInsnNode node) {
        ClassTransformer.log(ClassTransformer.getNodeString(node));
    }

    private static String getNodeString(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    private static boolean checkDesc(String desc, String expected) {
        return desc.equals(expected) || desc.equals(MethodSignature.obfuscate(expected));
    }

    private static boolean hasOptifine(String msg) {
        try {
            if (Class.forName("optifine.OptiFineTweaker") != null) {
                ClassTransformer.log("Optifine Detected. Disabling Patch for " + msg);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        transformers.put("net.minecraft.client.model.ModelBiped", ClassTransformer::transformModelBiped);
        transformers.put("net.minecraft.client.renderer.RenderItem", ClassTransformer::transformRenderItem);
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerArmorBase", ClassTransformer::transformLayerArmorBase);
        transformers.put("net.minecraft.client.renderer.entity.RenderBoat", ClassTransformer::transformRenderBoat);
        transformers.put("net.minecraft.entity.item.EntityBoat", ClassTransformer::transformEntityBoat);
        transformers.put("net.minecraft.block.BlockPistonBase", ClassTransformer::transformBlockPistonBase);
        transformers.put("net.minecraft.inventory.ContainerWorkbench", ClassTransformer::transformContainerWorkbench);
        transformers.put("net.minecraft.tileentity.TileEntityPiston", ClassTransformer::transformTileEntityPiston);
        transformers.put("net.minecraft.client.renderer.tileentity.TileEntityPistonRenderer", ClassTransformer::transformTileEntityPistonRenderer);
        transformers.put("net.minecraft.world.WorldServer", ClassTransformer::transformWorldServer);
        transformers.put("net.minecraft.client.renderer.BlockModelRenderer", ClassTransformer::transformBlockModelRenderer);
        invokestaticCount = 0;
        bipushCount = 0;
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static interface Transformer
    extends Function<byte[], byte[]> {
    }

    private static class MethodSignature {
        String funcName;
        String srgName;
        String obfName;
        String funcDesc;
        String obfDesc;

        public MethodSignature(String funcName, String srgName, String obfName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.obfName = obfName;
            this.funcDesc = funcDesc;
            this.obfDesc = MethodSignature.obfuscate(funcDesc);
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + ", " + this.obfName + "] Descriptor " + this.funcDesc + " / " + this.obfDesc;
        }

        private static String obfuscate(String desc) {
            for (String s : CLASS_MAPPINGS.keySet()) {
                if (!desc.contains(s)) continue;
                desc = desc.replaceAll(s, (String)CLASS_MAPPINGS.get(s));
            }
            return desc;
        }
    }
}

