/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class WandHelper {
    public static final String SPELL_ARRAY_KEY = "spells";
    public static final String SELECTED_SPELL_KEY = "selectedSpell";
    public static final String COOLDOWN_ARRAY_KEY = "cooldown";
    public static final String UPGRADES_KEY = "upgrades";
    private static final HashMap<Item, String> upgradeMap = new HashMap();

    public static Spell[] getSpells(ItemStack wand) {
        Spell[] spells = new Spell[]{};
        if (wand.func_77978_p() != null) {
            int[] spellIDs = wand.func_77978_p().func_74759_k(SPELL_ARRAY_KEY);
            spells = new Spell[spellIDs.length];
            for (int i = 0; i < spellIDs.length; ++i) {
                spells[i] = Spell.get(spellIDs[i]);
            }
        }
        return spells;
    }

    public static void setSpells(ItemStack wand, Spell[] spells) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        int[] spellIDs = new int[spells.length];
        for (int i = 0; i < spells.length; ++i) {
            spellIDs[i] = spells[i] != null ? spells[i].id() : Spells.none.id();
        }
        wand.func_77978_p().func_74783_a(SPELL_ARRAY_KEY, spellIDs);
    }

    public static Spell getCurrentSpell(ItemStack wand) {
        int selectedSpell;
        Spell[] spells = WandHelper.getSpells(wand);
        if (wand.func_77978_p() != null && (selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY)) < spells.length) {
            return spells[selectedSpell];
        }
        return Spells.none;
    }

    public static void selectNextSpell(ItemStack wand) {
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[5]);
        }
        if (wand.func_77978_p() != null) {
            int numberOfSpells = WandHelper.getSpells(wand).length;
            int selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
            selectedSpell = selectedSpell >= numberOfSpells - 1 ? 0 : ++selectedSpell;
            wand.func_77978_p().func_74768_a(SELECTED_SPELL_KEY, selectedSpell);
        }
    }

    public static void selectPreviousSpell(ItemStack wand) {
        if (WandHelper.getSpells(wand).length < 0) {
            WandHelper.setSpells(wand, new Spell[5]);
        }
        if (wand.func_77978_p() != null) {
            int numberOfSpells = WandHelper.getSpells(wand).length;
            int selectedSpell = wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY);
            selectedSpell = selectedSpell <= 0 ? numberOfSpells - 1 : --selectedSpell;
            wand.func_77978_p().func_74768_a(SELECTED_SPELL_KEY, selectedSpell);
        }
    }

    public static int[] getCooldowns(ItemStack wand) {
        int[] cooldowns = new int[]{};
        if (wand.func_77978_p() != null) {
            return wand.func_77978_p().func_74759_k(COOLDOWN_ARRAY_KEY);
        }
        return cooldowns;
    }

    public static void setCooldowns(ItemStack wand, int[] cooldowns) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        wand.func_77978_p().func_74783_a(COOLDOWN_ARRAY_KEY, cooldowns);
    }

    public static void decrementCooldowns(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        if (cooldowns.length == 0) {
            return;
        }
        for (int i = 0; i < cooldowns.length; ++i) {
            if (cooldowns[i] <= 0) continue;
            int n = i;
            cooldowns[n] = cooldowns[n] - 1;
        }
        WandHelper.setCooldowns(wand, cooldowns);
    }

    public static int getCurrentCooldown(ItemStack wand) {
        int[] cooldowns = WandHelper.getCooldowns(wand);
        if (cooldowns.length == 0) {
            return 0;
        }
        return cooldowns[wand.func_77978_p().func_74762_e(SELECTED_SPELL_KEY)];
    }

    public static void setCurrentCooldown(ItemStack wand, int cooldown) {
        int[] cooldowns;
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        if ((cooldowns = WandHelper.getCooldowns(wand)).length == 0) {
            cooldowns = new int[WandHelper.getSpells(wand).length];
        }
        cooldowns[wand.func_77978_p().func_74762_e((String)SELECTED_SPELL_KEY)] = cooldown;
        WandHelper.setCooldowns(wand, cooldowns);
    }

    public static int getUpgradeLevel(ItemStack wand, Item upgrade) {
        String key = upgradeMap.get(upgrade);
        if (wand.func_77978_p() != null && wand.func_77978_p().func_74764_b(UPGRADES_KEY) && key != null) {
            return wand.func_77978_p().func_74775_l(UPGRADES_KEY).func_74762_e(key);
        }
        return 0;
    }

    public static int getTotalUpgrades(ItemStack wand) {
        int totalUpgrades = 0;
        for (Item item : upgradeMap.keySet()) {
            totalUpgrades += WandHelper.getUpgradeLevel(wand, item);
        }
        return totalUpgrades;
    }

    public static void applyUpgrade(ItemStack wand, Item upgrade) {
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        if (!wand.func_77978_p().func_74764_b(UPGRADES_KEY)) {
            wand.func_77978_p().func_74782_a(UPGRADES_KEY, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound upgrades = wand.func_77978_p().func_74775_l(UPGRADES_KEY);
        String key = upgradeMap.get(upgrade);
        if (key != null) {
            upgrades.func_74768_a(key, upgrades.func_74762_e(key) + 1);
        }
        wand.func_77978_p().func_74782_a(UPGRADES_KEY, (NBTBase)upgrades);
    }

    public static boolean isWandUpgrade(Item upgrade) {
        return upgradeMap.containsKey(upgrade);
    }

    public static Set<Item> getSpecialUpgrades() {
        return Collections.unmodifiableSet(upgradeMap.keySet());
    }

    static String getIdentifier(Item upgrade) {
        if (!WandHelper.isWandUpgrade(upgrade)) {
            throw new IllegalArgumentException("Tried to get a wand upgrade key for an itemthat is not a registered special wand upgrade.");
        }
        return upgradeMap.get(upgrade);
    }

    public static void registerSpecialUpgrade(Item upgrade, String identifier) {
        if (upgradeMap.containsValue(identifier)) {
            throw new IllegalArgumentException("Duplicate wand upgrade identifier: " + identifier);
        }
        upgradeMap.put(upgrade, identifier);
    }

    static {
        upgradeMap.put(WizardryItems.condenser_upgrade, "condenser");
        upgradeMap.put(WizardryItems.storage_upgrade, "storage");
        upgradeMap.put(WizardryItems.siphon_upgrade, "siphon");
        upgradeMap.put(WizardryItems.range_upgrade, "range");
        upgradeMap.put(WizardryItems.duration_upgrade, "duration");
        upgradeMap.put(WizardryItems.cooldown_upgrade, COOLDOWN_ARRAY_KEY);
        upgradeMap.put(WizardryItems.blast_upgrade, "blast");
        upgradeMap.put(WizardryItems.attunement_upgrade, "attunement");
    }
}

