/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityStatue
extends TileEntity
implements ITickable {
    public EntityLiving creature;
    private NBTTagCompound entityCompound;
    private String entityName;
    private float entityYawHead;
    private float entityYawOffset;
    public boolean isIce;
    private int timer;
    private int lifetime = 600;
    public int destroyStage;
    public int parts;
    public int position = 1;

    public TileEntityStatue() {
    }

    public TileEntityStatue(boolean isIce) {
        this.isIce = isIce;
        this.timer = 0;
    }

    public void setCreatureAndPart(EntityLiving entity, int position, int parts) {
        this.creature = entity;
        this.position = position;
        this.parts = parts;
        if (position == 1) {
            this.creature.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5);
        }
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB cbb;
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        Block type = this.func_145838_q();
        if (this.creature != null) {
            bb = this.creature.func_184177_bl();
        } else if (type != null && (cbb = this.func_145831_w().func_180495_p(this.field_174879_c).func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c)) != null) {
            bb = cbb;
        }
        return bb;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public void func_73660_a() {
        ++this.timer;
        if (this.creature == null && this.entityName != null) {
            this.creature = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.entityName), (World)this.field_145850_b);
            if (this.creature != null) {
                this.creature.func_70020_e(this.entityCompound);
                this.creature.field_70759_as = this.entityYawHead;
                this.creature.field_70761_aq = this.entityYawOffset;
            }
        }
        if (!this.field_145850_b.field_72995_K && this.timer % 200 == 0 && this.timer > this.lifetime && !this.isIce && this.position == 1 && this.field_145850_b.func_175699_k(this.field_174879_c) < this.field_145850_b.field_73012_v.nextInt(12) - 3) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
        }
        if (!this.field_145850_b.field_72995_K && this.timer > this.lifetime && this.isIce && this.position == 1) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.position = tagCompound.func_74762_e("position");
        this.parts = tagCompound.func_74762_e("parts");
        this.entityCompound = tagCompound.func_74775_l("entity");
        this.entityName = tagCompound.func_74779_i("entityName");
        this.timer = tagCompound.func_74762_e("timer");
        this.lifetime = tagCompound.func_74762_e("lifetime");
        this.isIce = tagCompound.func_74767_n("isIce");
        this.entityYawHead = tagCompound.func_74760_g("entityYawHead");
        this.entityYawOffset = tagCompound.func_74760_g("entityYawOffset");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("position", this.position);
        tagCompound.func_74768_a("parts", this.parts);
        this.entityCompound = new NBTTagCompound();
        if (this.creature != null) {
            this.creature.func_189511_e(this.entityCompound);
            tagCompound.func_74778_a("entityName", EntityList.func_75621_b((Entity)this.creature));
            tagCompound.func_74776_a("entityYawHead", this.creature.field_70759_as);
            tagCompound.func_74776_a("entityYawOffset", this.creature.field_70761_aq);
        }
        tagCompound.func_74782_a("entity", (NBTBase)this.entityCompound);
        tagCompound.func_74768_a("timer", this.timer);
        tagCompound.func_74768_a("lifetime", this.lifetime);
        tagCompound.func_74757_a("isIce", this.isIce);
        return tagCompound;
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }
}

