/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.tileentity;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.item.ItemArcaneTome;
import electroblob.wizardry.item.ItemArmourUpgrade;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.SlotItemList;
import electroblob.wizardry.tileentity.SlotWandArmour;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ContainerArcaneWorkbench
extends Container {
    public TileEntityArcaneWorkbench tileentity;
    public static final ResourceLocation EMPTY_SLOT_CRYSTAL = new ResourceLocation("ebwizardry", "gui/empty_slot_crystal");
    public static final ResourceLocation EMPTY_SLOT_UPGRADE = new ResourceLocation("ebwizardry", "gui/empty_slot_upgrade");
    public static final int CRYSTAL_SLOT = 8;
    public static final int WAND_SLOT = 9;
    public static final int UPGRADE_SLOT = 10;
    private static final int[][][] SPELL_BOOK_SLOT_COORDS = new int[][][]{new int[][]{{80, 22}, {121, 51}, {106, 98}, {54, 98}, {39, 51}, {-999, -999}, {-999, -999}, {-999, -999}}, new int[][]{{80, 22}, {117, 43}, {117, 85}, {80, 106}, {43, 85}, {43, 43}, {-999, -999}, {-999, -999}}, new int[][]{{80, 22}, {113, 38}, {121, 74}, {98, 102}, {62, 102}, {39, 74}, {47, 38}, {-999, -999}}, new int[][]{{80, 22}, {111, 33}, {122, 64}, {111, 95}, {80, 106}, {49, 95}, {38, 64}, {49, 33}}};

    public ContainerArcaneWorkbench(IInventory inventory, TileEntityArcaneWorkbench tileentity) {
        this.tileentity = tileentity;
        ItemStack wand = tileentity.func_70301_a(9);
        for (int i = 0; i < 8; ++i) {
            this.func_75146_a(new SlotItemList(tileentity, i, -999, -999, 1, WizardryItems.spell_book));
        }
        this.func_75146_a(new SlotItemList(tileentity, 8, 8, 88, 64, WizardryItems.magic_crystal)).setBackgroundName(EMPTY_SLOT_CRYSTAL.toString());
        this.func_75146_a(new SlotWandArmour(tileentity, 9, 80, 64, this));
        HashSet<Item> upgrades = new HashSet<Item>(WandHelper.getSpecialUpgrades());
        upgrades.add(WizardryItems.arcane_tome);
        upgrades.add(WizardryItems.armour_upgrade);
        this.func_75146_a(new SlotItemList(tileentity, 10, 8, 106, 1, upgrades.toArray(new Item[0]))).setBackgroundName(EMPTY_SLOT_UPGRADE.toString());
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(inventory, x, 8 + x * 18, 196));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(inventory, 9 + x + y * 9, 8 + x * 18, 138 + y * 18));
            }
        }
        this.onSlotChanged(9, wand, null);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileentity.func_70300_a(player);
    }

    public void onSlotChanged(int slotNumber, ItemStack stack, EntityPlayer player) {
        if (slotNumber == 9) {
            if (!(stack.func_77973_b() instanceof ItemWand) && stack.func_77973_b() != WizardryItems.blank_scroll) {
                for (int i = 0; i < 8; ++i) {
                    Slot slot1 = this.func_75139_a(i);
                    slot1.field_75223_e = -100;
                    slot1.field_75221_f = -100;
                    ItemStack stack1 = slot1.func_75211_c();
                    ItemStack remainder = this.func_82846_b(player, i);
                    if (remainder != ItemStack.field_190927_a || stack1 == ItemStack.field_190927_a) continue;
                    slot1.func_75215_d(ItemStack.field_190927_a);
                    if (player == null) continue;
                    player.func_71019_a(stack1, false);
                }
            } else if (stack.func_77973_b() == WizardryItems.blank_scroll) {
                this.func_75139_a((int)0).field_75223_e = SPELL_BOOK_SLOT_COORDS[0][0][0];
                this.func_75139_a((int)0).field_75221_f = SPELL_BOOK_SLOT_COORDS[0][0][1];
                for (int i = 1; i < 8; ++i) {
                    Slot slot1 = this.func_75139_a(i);
                    slot1.field_75223_e = -100;
                    slot1.field_75221_f = -100;
                    ItemStack stack1 = slot1.func_75211_c();
                    ItemStack remainder = this.func_82846_b(player, i);
                    if (remainder != ItemStack.field_190927_a || stack1 == ItemStack.field_190927_a) continue;
                    slot1.func_75215_d(ItemStack.field_190927_a);
                    if (player == null) continue;
                    player.func_71019_a(stack1, false);
                }
            } else {
                for (int i = 0; i < 8; ++i) {
                    int n = WandHelper.getUpgradeLevel(stack, WizardryItems.attunement_upgrade);
                    int[] coords = SPELL_BOOK_SLOT_COORDS[n][i];
                    Slot slot1 = this.func_75139_a(i);
                    slot1.field_75223_e = coords[0];
                    slot1.field_75221_f = coords[1];
                    if (slot1.field_75223_e >= 0 && slot1.field_75221_f >= 0) continue;
                    ItemStack stack1 = slot1.func_75211_c();
                    ItemStack remainder = this.func_82846_b(player, i);
                    if (remainder != ItemStack.field_190927_a || stack1 == ItemStack.field_190927_a) continue;
                    slot1.func_75215_d(ItemStack.field_190927_a);
                    if (player == null) continue;
                    player.func_71019_a(stack1, false);
                }
            }
        }
        this.tileentity.sync();
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlotId) {
        ItemStack remainder = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            remainder = stack.func_77946_l();
            if (clickedSlotId <= 10) {
                if (!this.func_75135_a(stack, 11, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                int minSlotId = 0;
                int maxSlotId = 10;
                if (stack.func_77973_b() instanceof ItemSpellBook) {
                    minSlotId = 0;
                    maxSlotId = 7;
                } else if (stack.func_77973_b() == WizardryItems.magic_crystal) {
                    minSlotId = 8;
                    maxSlotId = 8;
                } else if (stack.func_77973_b() instanceof ItemWand || stack.func_77973_b() instanceof ItemWizardArmour || stack.func_77973_b() == WizardryItems.blank_scroll) {
                    minSlotId = 9;
                    maxSlotId = 9;
                } else if (stack.func_77973_b() instanceof ItemArcaneTome || stack.func_77973_b() instanceof ItemArmourUpgrade || WandHelper.isWandUpgrade(stack.func_77973_b())) {
                    minSlotId = 10;
                    maxSlotId = 10;
                } else {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack, minSlotId, maxSlotId + 1, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == remainder.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return remainder;
    }

    protected boolean func_75135_a(ItemStack stack, int minSlotID, int maxSlotID, boolean p_75135_4_) {
        for (int i = minSlotID; i < maxSlotID; ++i) {
            if (this.func_75139_a((int)i).field_75223_e < 0 || this.func_75139_a((int)i).field_75221_f < 0 || this.func_75139_a(i).func_75216_d()) continue;
            return super.func_75135_a(stack, minSlotID, maxSlotID, p_75135_4_);
        }
        return false;
    }

    public void onApplyButtonPressed(EntityPlayer player) {
        ItemStack wand = this.func_75139_a(9).func_75211_c();
        ItemStack[] spellBooks = new ItemStack[8];
        for (int i = 0; i < spellBooks.length; ++i) {
            spellBooks[i] = this.func_75139_a(i).func_75211_c();
        }
        ItemStack crystals = this.func_75139_a(8).func_75211_c();
        ItemStack upgrade = this.func_75139_a(10).func_75211_c();
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellBindEvent(player, this))) {
            return;
        }
        if (wand.func_77973_b() instanceof ItemWand) {
            if (upgrade.func_77973_b() == WizardryItems.arcane_tome) {
                switch (Tier.values()[upgrade.func_77952_i()]) {
                    case APPRENTICE: {
                        if (((ItemWand)wand.func_77973_b()).tier != Tier.BASIC) break;
                        ItemStack newWand = new ItemStack(WizardryUtilities.getWand(Tier.values()[upgrade.func_77952_i()], ((ItemWand)wand.func_77973_b()).element));
                        newWand.func_77982_d(wand.func_77978_p());
                        newWand.func_77964_b(newWand.func_77958_k() - (wand.func_77958_k() - wand.func_77952_i()));
                        this.func_75141_a(9, newWand);
                        this.func_75141_a(10, ItemStack.field_190927_a);
                        WizardryAdvancementTriggers.apprentice.triggerFor(player);
                        break;
                    }
                    case ADVANCED: {
                        if (((ItemWand)wand.func_77973_b()).tier != Tier.APPRENTICE) break;
                        ItemStack newWand = new ItemStack(WizardryUtilities.getWand(Tier.values()[upgrade.func_77952_i()], ((ItemWand)wand.func_77973_b()).element));
                        newWand.func_77982_d(wand.func_77978_p());
                        newWand.func_77964_b(newWand.func_77958_k() - (wand.func_77958_k() - wand.func_77952_i()));
                        this.func_75141_a(9, newWand);
                        this.func_75141_a(10, ItemStack.field_190927_a);
                        break;
                    }
                    case MASTER: {
                        if (((ItemWand)wand.func_77973_b()).tier != Tier.ADVANCED) break;
                        ItemStack newWand = new ItemStack(WizardryUtilities.getWand(Tier.values()[upgrade.func_77952_i()], ((ItemWand)wand.func_77973_b()).element));
                        newWand.func_77982_d(wand.func_77978_p());
                        newWand.func_77964_b(newWand.func_77958_k() - (wand.func_77958_k() - wand.func_77952_i()));
                        this.func_75141_a(9, newWand);
                        this.func_75141_a(10, ItemStack.field_190927_a);
                        WizardryAdvancementTriggers.master.triggerFor(player);
                        break;
                    }
                }
                wand = this.func_75139_a(9).func_75211_c();
            } else {
                int prevMana = wand.func_77958_k() - wand.func_77952_i();
                if (WandHelper.getTotalUpgrades(wand) < ((ItemWand)wand.func_77973_b()).tier.upgradeLimit && WandHelper.getUpgradeLevel(wand, upgrade.func_77973_b()) < 3) {
                    WandHelper.applyUpgrade(wand, upgrade.func_77973_b());
                    if (upgrade.func_77973_b() == WizardryItems.storage_upgrade) {
                        wand.func_77964_b(wand.func_77958_k() - prevMana);
                    }
                    if (upgrade.func_77973_b() == WizardryItems.attunement_upgrade) {
                        Spell[] spells = WandHelper.getSpells(wand);
                        Spell[] newSpells = new Spell[5 + WandHelper.getUpgradeLevel(wand, WizardryItems.attunement_upgrade)];
                        for (int i = 0; i < newSpells.length; ++i) {
                            newSpells[i] = i < spells.length && spells[i] != null ? spells[i] : Spells.none;
                        }
                        WandHelper.setSpells(wand, newSpells);
                        int[] cooldown = WandHelper.getCooldowns(wand);
                        int[] newCooldown = new int[5 + WandHelper.getUpgradeLevel(wand, WizardryItems.attunement_upgrade)];
                        if (cooldown.length > 0) {
                            for (int i = 0; i < cooldown.length; ++i) {
                                newCooldown[i] = cooldown[i];
                            }
                        }
                        WandHelper.setCooldowns(wand, newCooldown);
                    }
                    this.func_75139_a(10).func_75209_a(1);
                    WizardryAdvancementTriggers.special_upgrade.triggerFor(player);
                    if (WandHelper.getTotalUpgrades(wand) == Tier.MASTER.upgradeLimit) {
                        WizardryAdvancementTriggers.max_out_wand.triggerFor(player);
                    }
                }
            }
            Spell[] spells = WandHelper.getSpells(wand);
            if (spells.length <= 0) {
                spells = new Spell[5];
            }
            for (int i = 0; i < spells.length; ++i) {
                if (spellBooks[i] == ItemStack.field_190927_a || Spell.get((int)spellBooks[i].func_77952_i()).tier.level > ((ItemWand)wand.func_77973_b()).tier.level) continue;
                spells[i] = Spell.get(spellBooks[i].func_77952_i());
            }
            WandHelper.setSpells(wand, spells);
            if (crystals != ItemStack.field_190927_a) {
                int chargeDepleted = wand.func_77952_i();
                if (crystals.func_190916_E() * 100 < chargeDepleted) {
                    wand.func_77964_b(chargeDepleted - crystals.func_190916_E() * 100);
                    this.func_75139_a(8).func_75209_a(crystals.func_190916_E());
                } else if (chargeDepleted != 0) {
                    this.func_75139_a(8).func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
                    wand.func_77964_b(0);
                }
            }
        } else if (wand.func_77973_b() instanceof ItemWizardArmour) {
            if (upgrade.func_77973_b() == WizardryItems.armour_upgrade) {
                if (!wand.func_77942_o()) {
                    wand.func_77982_d(new NBTTagCompound());
                }
                if (!wand.func_77978_p().func_74764_b("legendary")) {
                    wand.func_77978_p().func_74757_a("legendary", true);
                    this.func_75141_a(10, ItemStack.field_190927_a);
                    WizardryAdvancementTriggers.legendary.triggerFor(player);
                }
            }
            if (crystals != ItemStack.field_190927_a) {
                int chargeDepleted = wand.func_77952_i();
                if (crystals.func_190916_E() * 100 < chargeDepleted) {
                    wand.func_77964_b(chargeDepleted - crystals.func_190916_E() * 100);
                    this.func_75139_a(8).func_75209_a(crystals.func_190916_E());
                } else if (chargeDepleted != 0) {
                    this.func_75139_a(8).func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
                    wand.func_77964_b(0);
                }
            }
        } else if (wand.func_77973_b() == WizardryItems.blank_scroll && spellBooks[0] != ItemStack.field_190927_a && (player.field_71075_bZ.field_75098_d || WizardData.get(player) != null && WizardData.get(player).hasSpellBeenDiscovered(Spell.get(spellBooks[0].func_77952_i()))) && crystals != ItemStack.field_190927_a && crystals.func_190916_E() * 100 > Spell.get((int)spellBooks[0].func_77952_i()).cost) {
            this.func_75139_a(8).func_75209_a((int)Math.ceil((double)Spell.get((int)spellBooks[0].func_77952_i()).cost / 100.0));
            this.func_75141_a(9, new ItemStack(WizardryItems.scroll, 1, spellBooks[0].func_77952_i()));
        }
    }
}

