/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Whirlwind
extends Spell {
    public Whirlwind() {
        super(Tier.APPRENTICE, 10, Element.EARTH, "whirlwind", SpellType.DEFENCE, 15, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (!world.field_72995_K) {
                target.field_70159_w = caster.func_70040_Z().field_72450_a * 2.0;
                target.field_70181_x = caster.func_70040_Z().field_72448_b * 2.0 + 1.0;
                target.field_70179_y = caster.func_70040_Z().field_72449_c * 2.0;
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
                }
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double x2 = caster.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5 + caster.func_70040_Z().field_72450_a * (double)caster.func_70032_d((Entity)target) * 0.5;
                    double y2 = WizardryUtilities.getPlayerEyesPos(caster) + (double)world.field_73012_v.nextFloat() - 0.5 + caster.func_70040_Z().field_72448_b * (double)caster.func_70032_d((Entity)target) * 0.5;
                    double z2 = caster.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5 + caster.func_70040_Z().field_72449_c * (double)caster.func_70032_d((Entity)target) * 0.5;
                    world.func_175688_a(EnumParticleTypes.CLOUD, x2, y2, z2, caster.func_70040_Z().field_72450_a, caster.func_70040_Z().field_72448_b, caster.func_70040_Z().field_72449_c, new int[0]);
                }
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 0.8f, world.field_73012_v.nextFloat() * 0.2f + 0.6f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                target.field_70159_w = caster.func_70040_Z().field_72450_a * 2.0;
                target.field_70181_x = caster.func_70040_Z().field_72448_b * 2.0 + 1.0;
                target.field_70179_y = caster.func_70040_Z().field_72449_c * 2.0;
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
                }
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double x2 = caster.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5 + caster.func_70040_Z().field_72450_a * (double)caster.func_70032_d((Entity)target) * 0.5;
                    double y2 = caster.field_70163_u + (double)caster.func_70047_e() + (double)world.field_73012_v.nextFloat() - 0.5 + caster.func_70040_Z().field_72448_b * (double)caster.func_70032_d((Entity)target) * 0.5;
                    double z2 = caster.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5 + caster.func_70040_Z().field_72449_c * (double)caster.func_70032_d((Entity)target) * 0.5;
                    world.func_175688_a(EnumParticleTypes.CLOUD, x2, y2, z2, caster.func_70040_Z().field_72450_a, caster.func_70040_Z().field_72448_b, caster.func_70040_Z().field_72449_c, new int[0]);
                }
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_ICE, 0.8f, world.field_73012_v.nextFloat() * 0.2f + 0.6f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

