/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WallOfFrost
extends Spell {
    public WallOfFrost() {
        super(Tier.MASTER, 15, Element.ICE, "wall_of_frost", SpellType.UTILITY, 0, EnumAction.NONE, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(10.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, true);
        if (rayTrace != null && !world.field_72995_K) {
            BlockPos pos = rayTrace.func_178782_a();
            if (WizardryUtilities.canBlockBeReplaced(world, pos)) {
                pos = pos.func_177972_a(rayTrace.field_178784_b.func_176734_d());
            }
            if (caster.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 2.0 && world.func_180495_p(pos).func_177230_c() != WizardryBlocks.ice_statue) {
                if (WizardryUtilities.canBlockBeReplaced(world, pos = pos.func_177972_a(rayTrace.field_178784_b))) {
                    world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                }
                if (rayTrace.field_178784_b == EnumFacing.UP && WizardryUtilities.canBlockBeReplaced(world, pos = pos.func_177972_a(rayTrace.field_178784_b))) {
                    world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                }
            }
        }
        for (int i = 0; i < 20; ++i) {
            if (!world.field_72995_K) continue;
            double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, look.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 8 + world.field_73012_v.nextInt(12), 0.4f, 0.6f, 1.0f);
            x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, look.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 8 + world.field_73012_v.nextInt(12), 1.0f, 1.0f, 1.0f);
        }
        if (ticksInUse % 12 == 0) {
            if (ticksInUse == 0) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 0.5f, 1.0f);
            }
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_ICE, 0.5f, 1.0f);
        }
        return true;
    }
}

