/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityTornado;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class Tornado
extends Spell {
    public Tornado() {
        super(Tier.ADVANCED, 35, Element.EARTH, "tornado", SpellType.ATTACK, 80, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            double x = caster.field_70165_t + caster.func_70040_Z().field_72450_a;
            double y = caster.field_70163_u;
            double z = caster.field_70161_v + caster.func_70040_Z().field_72449_c;
            EntityTornado tornado = new EntityTornado(world, x, y, z, (EntityLivingBase)caster, (int)(200.0f * modifiers.get(WizardryItems.duration_upgrade)), caster.func_70040_Z().field_72450_a / 3.0, caster.func_70040_Z().field_72449_c / 3.0, modifiers.get("damage"));
            world.func_72838_d((Entity)tornado);
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                double x = caster.field_70165_t + caster.func_70040_Z().field_72450_a;
                double y = caster.field_70163_u;
                double z = caster.field_70161_v + caster.func_70040_Z().field_72449_c;
                EntityTornado tornado = new EntityTornado(world, x, y, z, (EntityLivingBase)caster, (int)(200.0f * modifiers.get(WizardryItems.duration_upgrade)), caster.func_70040_Z().field_72450_a / 3.0, caster.func_70040_Z().field_72449_c / 3.0, modifiers.get("damage"));
                world.func_72838_d((Entity)tornado);
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_ICE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

