/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.projectile.EntityThunderbolt;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class Thunderbolt
extends Spell {
    public Thunderbolt() {
        super(Tier.BASIC, 10, Element.LIGHTNING, "thunderbolt", SpellType.ATTACK, 15, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityThunderbolt thunderbolt = new EntityThunderbolt(world, (EntityLivingBase)caster, modifiers.get("damage"));
            world.func_72838_d((Entity)thunderbolt);
        }
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 0.8f, world.field_73012_v.nextFloat() * 0.2f + 0.8f);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityThunderbolt thunderbolt = new EntityThunderbolt(world, (EntityLivingBase)caster, modifiers.get("damage"));
                thunderbolt.directTowards((Entity)target, 2.5f);
                world.func_72838_d((Entity)thunderbolt);
            }
            caster.func_184185_a(WizardrySounds.SPELL_ICE, 0.8f, world.field_73012_v.nextFloat() * 0.2f + 0.8f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

