/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class Spell
extends IForgeRegistryEntry.Impl<Spell>
implements Comparable<Spell> {
    public static IForgeRegistry<Spell> registry;
    public final Tier tier;
    public final int cost;
    public final Element element;
    private final String unlocalisedName;
    public final SpellType type;
    public final int cooldown;
    public final EnumAction action;
    public final boolean isContinuous;
    private final ResourceLocation icon;
    private final String modID;
    private boolean isEnabled = true;
    public static Predicate<Spell> allSpells;
    public static Predicate<Spell> enabledSpells;
    public static Predicate<Spell> nonContinuousSpells;
    public static Predicate<Spell> npcSpells;

    public Spell(Tier tier, int cost, Element element, String name, SpellType type, int cooldown, EnumAction action, boolean isContinuous) {
        this(tier, cost, element, name, type, cooldown, action, isContinuous, "ebwizardry");
    }

    public Spell(Tier tier, int cost, Element element, String name, SpellType type, int cooldown, EnumAction action, boolean isContinuous, String modID) {
        this.tier = tier;
        this.cost = cost;
        this.element = element;
        this.type = type;
        this.cooldown = cooldown;
        this.action = action;
        this.isContinuous = isContinuous;
        this.modID = modID;
        this.setRegistryName(modID, name);
        this.unlocalisedName = this.getRegistryName().toString();
        this.icon = new ResourceLocation(this.modID, "textures/spells/" + name + ".png");
    }

    public abstract boolean cast(World var1, EntityPlayer var2, EnumHand var3, int var4, SpellModifiers var5);

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean canBeCastByNPCs() {
        return false;
    }

    public boolean doesSpellRequirePacket() {
        return true;
    }

    public final int id() {
        return ((ForgeRegistry)registry).getID((IForgeRegistryEntry)this);
    }

    public final String getModID() {
        return this.modID;
    }

    public final ResourceLocation getIcon() {
        return this.icon;
    }

    public final String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return I18n.func_135052_a((String)("spell." + this.unlocalisedName), (Object[])new Object[0]);
    }

    public TextComponentTranslation getNameForTranslation() {
        return new TextComponentTranslation("spell." + this.unlocalisedName, new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return this.element.getFormattingCode() + I18n.func_135052_a((String)("spell." + this.unlocalisedName), (Object[])new Object[0]);
    }

    public ITextComponent getNameForTranslationFormatted() {
        return new TextComponentTranslation("spell." + this.unlocalisedName, new Object[0]).func_150255_a(this.element.getColour());
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        return I18n.func_135052_a((String)("spell." + this.unlocalisedName + ".desc"), (Object[])new Object[0]);
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public final int compareTo(Spell spell) {
        if (this.tier.ordinal() > spell.tier.ordinal()) {
            return 1;
        }
        if (this.tier.ordinal() < spell.tier.ordinal()) {
            return -1;
        }
        if (this.element.ordinal() > spell.element.ordinal()) {
            return 1;
        }
        if (this.element.ordinal() < spell.element.ordinal()) {
            return -1;
        }
        return 0;
    }

    public static int getTotalSpellCount() {
        return registry.getValuesCollection().size() - 1;
    }

    public static Spell get(int id) {
        if (id < 0 || id >= registry.getValuesCollection().size()) {
            return Spells.none;
        }
        Spell spell = (Spell)((ForgeRegistry)registry).getValue(id);
        return spell == null ? Spells.none : spell;
    }

    public static Spell get(String name) {
        ResourceLocation key = new ResourceLocation(name);
        if (key.func_110624_b().equals("minecraft")) {
            key = new ResourceLocation("ebwizardry", name);
        }
        return (Spell)((ForgeRegistry)registry).getValue(key);
    }

    public static String[] getSpellNames() {
        HashSet keys = new HashSet(registry.getKeys());
        keys.remove(registry.getKey((IForgeRegistryEntry)Spells.none));
        return (String[])keys.stream().map(ResourceLocation::toString).toArray(String[]::new);
    }

    public static List<Spell> getSpells(Predicate<Spell> filter) {
        return registry.getValuesCollection().stream().filter(filter.and(p -> p != Spells.none)).collect(Collectors.toList());
    }

    static {
        allSpells = s -> true;
        enabledSpells = Spell::isEnabled;
        nonContinuousSpells = s -> !s.isContinuous;
        npcSpells = s -> s.isEnabled() && s.canBeCastByNPCs();
    }

    public static class TierElementFilter
    implements Predicate<Spell> {
        private Tier tier;
        private Element element;

        public TierElementFilter(Tier tier, Element element) {
            this.tier = tier;
            this.element = element;
        }

        @Override
        public boolean test(Spell spell) {
            return !(!spell.isEnabled() || this.tier != null && spell.tier != this.tier || this.element != null && spell.element != this.element);
        }
    }
}

