/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpectralPathway
extends Spell {
    public SpectralPathway() {
        super(Tier.ADVANCED, 40, Element.SORCERY, "spectral_pathway", SpellType.UTILITY, 300, EnumAction.BOW, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster).func_177230_c() == Blocks.field_150350_a || WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster).func_177230_c() == WizardryBlocks.spectral_block) {
            return false;
        }
        EnumFacing direction = caster.func_174811_aO();
        boolean flag = false;
        if (!world.field_72995_K) {
            int baseLength = 15;
            BlockPos origin = new BlockPos((double)Math.round(caster.field_70165_t), (double)((int)caster.func_174813_aQ().field_72338_b - 1), (double)Math.round(caster.field_70161_v));
            int startPoint = direction.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? -1 : 0;
            for (int i = 0; i < (int)((float)baseLength * modifiers.get(WizardryItems.range_upgrade)); ++i) {
                flag = SpectralPathway.placePathwayBlockIfPossible(world, origin.func_177967_a(direction, startPoint + i), modifiers.get(WizardryItems.duration_upgrade)) || flag;
                flag = SpectralPathway.placePathwayBlockIfPossible(world, origin.func_177967_a(direction, startPoint + i).func_177972_a(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)direction.func_176746_e().func_176740_k())), modifiers.get(WizardryItems.duration_upgrade)) || flag;
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION_LARGE, 1.0f, 1.0f);
        return flag;
    }

    private static boolean placePathwayBlockIfPossible(World world, BlockPos pos, float durationMultiplier) {
        if (WizardryUtilities.canBlockBeReplacedB(world, pos)) {
            world.func_175656_a(pos, WizardryBlocks.spectral_block.func_176223_P());
            if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(1200.0f * durationMultiplier));
            }
            return true;
        }
        return false;
    }
}

