/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class MindTrick
extends Spell {
    public MindTrick() {
        super(Tier.BASIC, 10, Element.NECROMANCY, "mind_trick", SpellType.ATTACK, 40, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        block1: {
            EntityLivingBase target;
            block4: {
                block2: {
                    block3: {
                        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 8.0f * modifiers.get(WizardryItems.range_upgrade));
                        if (rayTrace == null || rayTrace.field_72308_g == null || !WizardryUtilities.isLiving(rayTrace.field_72308_g)) break block1;
                        target = (EntityLivingBase)rayTrace.field_72308_g;
                        if (world.field_72995_K) break block2;
                        if (!(target instanceof EntityPlayer)) break block3;
                        target.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (int)(300.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                        break block4;
                    }
                    if (!(target instanceof EntityLiving)) break block4;
                    ((EntityLiving)target).func_70624_b(null);
                    target.func_70690_d(new PotionEffect(WizardryPotions.mind_trick, (int)(300.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                    break block4;
                }
                for (int i = 0; i < 10; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.8f, 0.2f, 1.0f);
                }
            }
            target.func_184185_a(WizardrySounds.SPELL_DEFLECTION, 0.7f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        block1: {
            block4: {
                block2: {
                    block3: {
                        if (target == null) break block1;
                        if (world.field_72995_K) break block2;
                        if (!(target instanceof EntityPlayer)) break block3;
                        target.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (int)(300.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                        break block4;
                    }
                    if (!(target instanceof EntityLiving)) break block4;
                    ((EntityLiving)target).func_70624_b(null);
                    target.func_70690_d(new PotionEffect(WizardryPotions.mind_trick, (int)(300.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                    break block4;
                }
                for (int i = 0; i < 10; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.8f, 0.2f, 1.0f);
                }
            }
            target.func_184185_a(WizardrySounds.SPELL_DEFLECTION, 0.7f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && event.getEntityLiving().func_70644_a(WizardryPotions.mind_trick)) {
            event.getEntityLiving().func_184589_d(WizardryPotions.mind_trick);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if ((event.getEntityLiving().func_70644_a(WizardryPotions.mind_trick) || event.getEntityLiving().func_70644_a(WizardryPotions.fear)) && event.getEntityLiving() instanceof EntityLiving && event.getTarget() != null) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }
}

