/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityLightningPulse;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class LightningPulse
extends Spell {
    public LightningPulse() {
        super(Tier.ADVANCED, 25, Element.LIGHTNING, "lightning_pulse", SpellType.ATTACK, 75, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70122_E) {
            List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(3.0 * (double)modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
            for (EntityLivingBase target : targets) {
                if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target)) continue;
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 8.0f * modifiers.get("damage"));
                if (world.field_72995_K) continue;
                double dx = target.field_70165_t - caster.field_70165_t;
                double dz = target.field_70161_v - caster.field_70161_v;
                double vectorLength = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                target.field_70159_w = 0.8 * (dx /= vectorLength);
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.8 * (dz /= vectorLength);
                if (!(target instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
            }
            if (!world.field_72995_K) {
                EntityLightningPulse lightningpulse = new EntityLightningPulse(world, caster.field_70165_t, caster.func_174813_aQ().field_72338_b, caster.field_70161_v, (EntityLivingBase)caster, 7, modifiers.get("damage"));
                world.func_72838_d((Entity)lightningpulse);
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LIGHTNING, 1.0f, 1.0f);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_SHOCKWAVE, 2.0f, 1.0f);
            return true;
        }
        return false;
    }
}

