/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class IceAge
extends Spell {
    private static final int baseDuration = 1200;

    public IceAge() {
        super(Tier.MASTER, 70, Element.ICE, "ice_age", SpellType.ATTACK, 250, EnumAction.BOW, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos;
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(7.0f * modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target) || world.field_72995_K) continue;
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube) {
                // empty if block
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (target instanceof EntityBlaze) {
                WizardryAdvancementTriggers.freeze_blaze.triggerFor(caster);
            }
            if (!(target instanceof EntityLiving)) continue;
            target.field_70737_aN = 0;
            pos = new BlockPos((Entity)target);
            if (((double)target.field_70131_O < 1.2 || target.func_70631_g_()) && WizardryUtilities.canBlockBeReplaced(world, pos)) {
                world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart((EntityLiving)target, 1, 1);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(1200.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                target.func_70106_y();
                target.func_184185_a(WizardrySounds.SPELL_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                continue;
            }
            if ((double)target.field_70131_O < 2.5 && WizardryUtilities.canBlockBeReplaced(world, pos) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
                world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart((EntityLiving)target, 1, 2);
                    ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(1200.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                world.func_175656_a(pos.func_177984_a(), WizardryBlocks.ice_statue.func_176223_P());
                if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart((EntityLiving)target, 2, 2);
                }
                target.func_70106_y();
                target.func_184185_a(WizardrySounds.SPELL_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                continue;
            }
            if (!WizardryUtilities.canBlockBeReplaced(world, pos) || !WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a()) || !WizardryUtilities.canBlockBeReplaced(world, pos.func_177981_b(2))) continue;
            world.func_175656_a(pos, WizardryBlocks.ice_statue.func_176223_P());
            if (world.func_175625_s(pos) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos)).setCreatureAndPart((EntityLiving)target, 1, 3);
                ((TileEntityStatue)world.func_175625_s(pos)).setLifetime((int)(1200.0f * modifiers.get(WizardryItems.duration_upgrade)));
            }
            world.func_175656_a(pos.func_177984_a(), WizardryBlocks.ice_statue.func_176223_P());
            if (world.func_175625_s(pos.func_177984_a()) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos.func_177984_a())).setCreatureAndPart((EntityLiving)target, 2, 3);
            }
            world.func_175656_a(pos.func_177981_b(2), WizardryBlocks.ice_statue.func_176223_P());
            if (world.func_175625_s(pos.func_177981_b(2)) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_175625_s(pos.func_177981_b(2))).setCreatureAndPart((EntityLiving)target, 3, 3);
            }
            target.func_70106_y();
            target.func_184185_a(WizardrySounds.SPELL_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        if (!world.field_72995_K) {
            for (int i = -7; i < 8; ++i) {
                for (int j = -7; j < 8; ++j) {
                    pos = new BlockPos((Entity)caster).func_177982_a(i, 0, j);
                    int y = WizardryUtilities.getNearestFloorLevelB(world, new BlockPos((Vec3i)pos), 7);
                    pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                    double dist = caster.func_70011_f((double)((int)caster.field_70165_t + i), (double)y, (double)((int)caster.field_70161_v + j));
                    if (y == -1 || world.field_73012_v.nextInt((int)dist * 2 + 1) >= 7 || !(dist < 8.0)) continue;
                    if (world.func_180495_p(pos.func_177977_b()) == Blocks.field_150355_j.func_176223_P()) {
                        world.func_175656_a(pos.func_177977_b(), Blocks.field_150432_aD.func_176223_P());
                        continue;
                    }
                    if (world.func_180495_p(pos.func_177977_b()) == Blocks.field_150353_l.func_176223_P()) {
                        world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (world.func_180495_p(pos.func_177977_b()) == Blocks.field_150356_k.func_176223_P()) {
                        world.func_175656_a(pos.func_177977_b(), Blocks.field_150347_e.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                }
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 0.7f, 1.0f);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_WIND, 1.0f, 1.0f);
        return true;
    }
}

