/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Freeze
extends Spell {
    public Freeze() {
        super(Tier.BASIC, 5, Element.ICE, "freeze", SpellType.ATTACK, 10, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && WizardryUtilities.isLiving(rayTrace.field_72308_g)) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube || target instanceof EntityBlazeMinion) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FROST), 3.0f * modifiers.get("damage"));
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                if (!world.field_72995_K) {
                    caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                }
            } else {
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(200.0f * modifiers.get(WizardryItems.duration_upgrade)), 1));
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SNOW, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, -0.02, 0.0, 40 + world.field_73012_v.nextInt(10));
                }
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        rayTrace = WizardryUtilities.rayTrace(10.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, true);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a();
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && !world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
            } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l && !world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
            } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150356_k && !world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
            } else if (rayTrace.field_178784_b == EnumFacing.UP && !world.field_72995_K && world.isSideSolid(pos, EnumFacing.UP) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
            }
            if (world.field_72995_K) {
                double dx = (double)pos.func_177958_n() + 0.5 - caster.field_70165_t;
                double dy = (double)pos.func_177956_o() + 0.5 - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = (double)pos.func_177952_p() + 0.5 - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 20 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 20 + world.field_73012_v.nextInt(8), 1.0f, 1.0f, 1.0f);
                }
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube || target instanceof EntityBlazeMinion) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FROST), 3.0f * modifiers.get("damage"));
            }
            if (!world.field_72995_K && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(200.0f * modifiers.get(WizardryItems.duration_upgrade)), 1));
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (caster.field_70163_u + (double)caster.func_70047_e());
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SNOW, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, -0.02, 0.0, 40 + world.field_73012_v.nextInt(10));
                }
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_ICE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

