/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.projectile.EntityForceArrow;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ForceArrow
extends Spell {
    public ForceArrow() {
        super(Tier.APPRENTICE, 15, Element.SORCERY, "force_arrow", SpellType.ATTACK, 20, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityForceArrow forceArrow = new EntityForceArrow(world, (EntityLivingBase)caster, 1.0f * modifiers.get(WizardryItems.range_upgrade), modifiers.get("damage"));
            world.func_72838_d((Entity)forceArrow);
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_FORCE, 1.0f, 1.2f + world.field_73012_v.nextFloat() * 0.2f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityForceArrow forceArrow = new EntityForceArrow(world, (EntityLivingBase)caster, (Entity)target, 1.0f * modifiers.get(WizardryItems.range_upgrade), 2.0f, modifiers.get("damage"));
                world.func_72838_d((Entity)forceArrow);
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_FORCE, 1.0f, 1.2f + world.field_73012_v.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

