/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class FireSigil
extends Spell {
    public FireSigil() {
        super(Tier.APPRENTICE, 10, Element.FIRE, "fire_sigil", SpellType.ATTACK, 20, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(10.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && rayTrace.field_178784_b == EnumFacing.UP) {
            if (!world.field_72995_K) {
                double x = rayTrace.field_72307_f.field_72450_a;
                double y = rayTrace.field_72307_f.field_72448_b;
                double z = rayTrace.field_72307_f.field_72449_c;
                EntityFireSigil firesigil = new EntityFireSigil(world, x, y, z, (EntityLivingBase)caster, modifiers.get("damage"));
                world.func_72838_d((Entity)firesigil);
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187649_bu, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

