/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class Earthquake
extends Spell {
    public Earthquake() {
        super(Tier.MASTER, 75, Element.EARTH, "earthquake", SpellType.ATTACK, 250, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70122_E) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityEarthquake(world, caster.field_70165_t, caster.func_174813_aQ().field_72338_b, caster.field_70161_v, (EntityLivingBase)caster, (int)(20.0f * modifiers.get(WizardryItems.blast_upgrade)), modifiers.get("damage")));
            } else {
                world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                for (int i = 0; i < 40; ++i) {
                    double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                    if (block == null) continue;
                    world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174813_aQ().field_72338_b, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
                }
            }
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_EARTHQUAKE, 2.0f, 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }
}

