/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Cobwebs
extends Spell {
    private static final int baseDuration = 400;

    public Cobwebs() {
        super(Tier.ADVANCED, 30, Element.EARTH, "cobwebs", SpellType.ATTACK, 70, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(12.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, true);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            boolean flag = false;
            BlockPos pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b);
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, WizardryBlocks.vanishing_cobweb.func_176223_P());
                    if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                        ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                    }
                }
                flag = true;
            }
            for (EnumFacing side : EnumFacing.values()) {
                BlockPos pos1 = pos.func_177972_a(side);
                if (!world.func_175623_d(pos1)) continue;
                if (!world.field_72995_K) {
                    world.func_175656_a(pos1, WizardryBlocks.vanishing_cobweb.func_176223_P());
                    if (world.func_175625_s(pos1) instanceof TileEntityTimer) {
                        ((TileEntityTimer)world.func_175625_s(pos1)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                    }
                }
                flag = true;
            }
            if (flag) {
                caster.func_184609_a(hand);
                WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187659_cY, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            int x = MathHelper.func_76128_c((double)target.field_70165_t);
            int y = (int)target.func_174813_aQ().field_72338_b;
            int z = MathHelper.func_76128_c((double)target.field_70161_v);
            boolean flag = false;
            BlockPos pos = new BlockPos(x, y, z);
            if (world.func_175623_d(pos)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, WizardryBlocks.vanishing_cobweb.func_176223_P());
                    if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                        ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                    }
                }
                flag = true;
            }
            for (EnumFacing side : EnumFacing.values()) {
                BlockPos pos1 = pos.func_177972_a(side);
                if (!world.func_175623_d(pos1)) continue;
                if (!world.field_72995_K) {
                    world.func_175656_a(pos1, WizardryBlocks.vanishing_cobweb.func_176223_P());
                    if (world.func_175625_s(pos1) instanceof TileEntityTimer) {
                        ((TileEntityTimer)world.func_175625_s(pos1)).setLifetime((int)(400.0f * modifiers.get(WizardryItems.duration_upgrade)));
                    }
                }
                flag = true;
            }
            if (flag) {
                caster.func_184609_a(hand);
                caster.func_184185_a(SoundEvents.field_187659_cY, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

