/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Blizzard
extends Spell {
    public Blizzard() {
        super(Tier.ADVANCED, 40, Element.ICE, "blizzard", SpellType.ATTACK, 100, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(20.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.field_72995_K) {
                double x = rayTrace.field_72307_f.field_72450_a;
                double y = rayTrace.field_72307_f.field_72448_b;
                double z = rayTrace.field_72307_f.field_72449_c;
                EntityBlizzard blizzard = new EntityBlizzard(world, x, y + 0.5, z, (EntityLivingBase)caster, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), modifiers.get("damage"));
                world.func_72838_d((Entity)blizzard);
            }
            caster.func_184609_a(hand);
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_ICE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                double x = target.field_70165_t;
                double y = target.field_70163_u;
                double z = target.field_70161_v;
                EntityBlizzard blizzard = new EntityBlizzard(world, x, y + 0.5, z, (EntityLivingBase)caster, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), modifiers.get("damage"));
                world.func_72838_d((Entity)blizzard);
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_ICE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

