/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ArcaneJammer
extends Spell {
    public ArcaneJammer() {
        super(Tier.ADVANCED, 30, Element.HEALING, "arcane_jammer", SpellType.ATTACK, 50, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && WizardryUtilities.isLiving(rayTrace.field_72308_g)) {
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (entity instanceof EntityWizard) {
                WizardryAdvancementTriggers.jam_wizard.triggerFor(caster);
            }
            if (!world.field_72995_K) {
                entity.func_70690_d(new PotionEffect(WizardryPotions.arcane_jammer, (int)(300.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 0.9f, 0.3f, 0.7f);
            }
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_DEFLECTION, 0.7f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                target.func_70690_d(new PotionEffect(WizardryPotions.arcane_jammer, (int)(300.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
            }
            if (world.field_72995_K) {
                double dx = (target.field_70165_t - caster.field_70165_t) / (double)caster.func_70032_d((Entity)target);
                double dy = (target.field_70163_u - caster.field_70163_u) / (double)caster.func_70032_d((Entity)target);
                double dz = (target.field_70161_v - caster.field_70161_v) / (double)caster.func_70032_d((Entity)target);
                for (int i = 1; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                    double x1 = caster.field_70165_t + dx * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + dy * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double z1 = caster.field_70161_v + dz * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 0.9f, 0.3f, 0.7f);
                }
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(WizardrySounds.SPELL_DEFLECTION, 0.7f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }

    @SubscribeEvent
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getEntityLiving().func_70644_a(WizardryPotions.arcane_jammer)) {
            event.setCanceled(true);
        }
    }
}

