/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import com.google.common.collect.Lists;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.entity.construct.EntityForcefield;
import electroblob.wizardry.entity.construct.EntityFrostSigil;
import electroblob.wizardry.entity.construct.EntityHailstorm;
import electroblob.wizardry.entity.construct.EntityHammer;
import electroblob.wizardry.entity.construct.EntityHealAura;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.entity.construct.EntityLightningPulse;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.construct.EntityTornado;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityMagicSlime;
import electroblob.wizardry.entity.living.EntityPhoenix;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntitySilverfishMinion;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntitySpiderMinion;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityWitherSkeletonMinion;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.entity.projectile.EntityDarknessOrb;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityFirebolt;
import electroblob.wizardry.entity.projectile.EntityFirebomb;
import electroblob.wizardry.entity.projectile.EntityForceArrow;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceCharge;
import electroblob.wizardry.entity.projectile.EntityIceLance;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.entity.projectile.EntityLightningArrow;
import electroblob.wizardry.entity.projectile.EntityLightningDisc;
import electroblob.wizardry.entity.projectile.EntityMagicMissile;
import electroblob.wizardry.entity.projectile.EntityPoisonBomb;
import electroblob.wizardry.entity.projectile.EntitySmokeBomb;
import electroblob.wizardry.entity.projectile.EntitySpark;
import electroblob.wizardry.entity.projectile.EntitySparkBomb;
import electroblob.wizardry.entity.projectile.EntityThunderbolt;
import electroblob.wizardry.loot.RandomSpell;
import electroblob.wizardry.loot.WizardSpell;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.tileentity.TileEntityMagicLight;
import electroblob.wizardry.tileentity.TileEntityPlayerSave;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public final class WizardryRegistry {
    private static final int LIVING_UPDATE_INTERVAL = 3;
    private static final int PROJECTILE_UPDATE_INTERVAL = 10;

    public static void registerLoot() {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomSpell.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new WizardSpell.Serializer());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/wizard_tower"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/dungeon_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/novice_wands"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/wizard_armour"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/arcane_tomes"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/wand_upgrades"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "entities/evil_wizard"));
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityArcaneWorkbench.class, (String)"ebwizardryArcaneWorkbenchTileEntity");
        GameRegistry.registerTileEntity(TileEntityStatue.class, (String)"ebwizardryPetrifiedStoneTileEntity");
        GameRegistry.registerTileEntity(TileEntityMagicLight.class, (String)"ebwizardryMagicLightTileEntity");
        GameRegistry.registerTileEntity(TileEntityTimer.class, (String)"ebwizardryTimerTileEntity");
        GameRegistry.registerTileEntity(TileEntityPlayerSave.class, (String)"ebwizardryTileEntityPlayerSave");
    }

    public static void registerEntities() {
        int id = 0;
        WizardryRegistry.registerEntity(EntityZombieMinion.class, "zombie_minion", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityMagicMissile.class, "magic_missile", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityArc.class, "arc", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntitySkeletonMinion.class, "skeleton_minion", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntitySparkBomb.class, "spark_bomb", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntitySpiritWolf.class, "spirit_wolf", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityIceShard.class, "ice_shard", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityBlazeMinion.class, "blaze_minion", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityIceWraith.class, "ice_wraith", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityLightningWraith.class, "lightning_wraith", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityBlackHole.class, "black_hole", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityShield.class, "shield", id++, 128, 1, true);
        WizardryRegistry.registerEntity(EntityMeteor.class, "meteor", id++, 128, 5, true);
        WizardryRegistry.registerEntity(EntityBlizzard.class, "blizzard", id++, 128, 10, false);
        WizardryRegistry.registerEntityAndEgg(EntityWizard.class, "wizard", id++, 128, 3, true, 1648990, 15635218);
        WizardryRegistry.registerEntity(EntityBubble.class, "bubble", id++, 128, 3, false);
        WizardryRegistry.registerEntity(EntityTornado.class, "tornado", id++, 128, 1, false);
        WizardryRegistry.registerEntity(EntityHammer.class, "lightning_hammer", id++, 128, 1, true);
        WizardryRegistry.registerEntity(EntityFirebomb.class, "firebomb", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityForceOrb.class, "force_orb", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityArrowRain.class, "arrow_rain", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntitySpark.class, "spark", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityShadowWraith.class, "shadow_wraith", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityDarknessOrb.class, "darkness_orb", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntitySpiderMinion.class, "spider_minion", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityHealAura.class, "healing_aura", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityFireSigil.class, "fire_sigil", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityFrostSigil.class, "frost_sigil", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityLightningSigil.class, "lightning_sigil", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityLightningArrow.class, "lightning_arrow", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityFirebolt.class, "firebolt", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityPoisonBomb.class, "poison_bomb", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityIceCharge.class, "ice_charge", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityForceArrow.class, "force_arrow", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityDart.class, "dart", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityMagicSlime.class, "magic_slime", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityForcefield.class, "forcefield", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityFireRing.class, "ring_of_fire", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityLightningDisc.class, "lightning_disc", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityThunderbolt.class, "thunderbolt", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityIceGiant.class, "ice_giant", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntitySpiritHorse.class, "spirit_horse", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityPhoenix.class, "phoenix", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntitySilverfishMinion.class, "silverfish_minion", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityDecay.class, "decay", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityStormElemental.class, "storm_elemental", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityEarthquake.class, "earthquake", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityIceLance.class, "ice_lance", id++, 128, 10, true);
        WizardryRegistry.registerEntity(EntityHailstorm.class, "hailstorm", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntitySmokeBomb.class, "smoke_bomb", id++, 128, 10, true);
        WizardryRegistry.registerEntityAndEgg(EntityEvilWizard.class, "evil_wizard", id++, 128, 3, true, 2688004, 15635218);
        WizardryRegistry.registerEntity(EntityDecoy.class, "decoy", id++, 128, 3, true);
        WizardryRegistry.registerEntity(EntityIceSpike.class, "ice_spike", id++, 128, 1, true);
        WizardryRegistry.registerEntity(EntityLightningPulse.class, "lightning_pulse", id++, 128, 10, false);
        WizardryRegistry.registerEntity(EntityWitherSkeletonMinion.class, "wither_skeleton_minion", id++, 128, 3, true);
        ArrayList biomes = Lists.newArrayList();
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            biomes.add(biome);
        }
        biomes.remove(Biomes.field_76789_p);
        biomes.remove(Biomes.field_76788_q);
        EntityRegistry.addSpawn(EntityEvilWizard.class, (int)3, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes.toArray(new Biome[biomes.size()]));
    }

    private static void registerEntity(Class<? extends Entity> entityClass, String name, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ResourceLocation registryName = new ResourceLocation("ebwizardry", name);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)id, (Object)Wizardry.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    private static void registerEntityAndEgg(Class<? extends Entity> entityClass, String name, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggColour, int spotColour) {
        ResourceLocation registryName = new ResourceLocation("ebwizardry", name);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)id, (Object)Wizardry.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        EntityRegistry.registerEgg((ResourceLocation)registryName, (int)eggColour, (int)spotColour);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        ItemStack magicCrystalStack = new ItemStack(WizardryItems.magic_crystal);
        ItemStack magicWandStack = new ItemStack(WizardryItems.magic_wand, 1, Tier.BASIC.maxCharge);
        ItemStack goldNuggetStack = new ItemStack(Items.field_151074_bl);
        ItemStack stickStack = new ItemStack(Items.field_151055_y);
        ItemStack bookStack = new ItemStack(Items.field_151122_aG);
        ItemStack spellBookStack = new ItemStack(WizardryItems.spell_book, 1, Spells.magic_missile.id());
        Ingredient crystalFlowerStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(WizardryBlocks.crystal_flower)});
        ItemStack magicCrystalStack1 = new ItemStack(WizardryItems.magic_crystal, 2);
        ItemStack magicCrystalStack2 = new ItemStack(WizardryItems.magic_crystal, 9);
        Ingredient crystalBlockStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(WizardryBlocks.crystal_block)});
        ItemStack manaFlaskStack = new ItemStack(WizardryItems.mana_flask);
        Ingredient bottleStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151069_bo)});
        Ingredient gunpowderStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151016_H)});
        Ingredient blazePowderStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151065_br)});
        Ingredient spiderEyeStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151070_bp)});
        Ingredient coalStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE)});
        ItemStack firebombStack = new ItemStack(WizardryItems.firebomb, 3);
        ItemStack poisonBombStack = new ItemStack(WizardryItems.poison_bomb, 3);
        ItemStack smokeBombStack = new ItemStack(WizardryItems.smoke_bomb, 3);
        ItemStack scrollStack = new ItemStack(WizardryItems.blank_scroll);
        Ingredient paperStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151121_aF)});
        Ingredient stringStack = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151007_F)});
        registry.register(new ShapedOreRecipe(null, magicWandStack, new Object[]{"  x", " y ", "z  ", Character.valueOf('x'), magicCrystalStack, Character.valueOf('y'), stickStack, Character.valueOf('z'), goldNuggetStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/magic_wand")));
        registry.register(new ShapedOreRecipe(null, spellBookStack, new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), magicCrystalStack, Character.valueOf('y'), bookStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/spellbook")));
        registry.register(new ShapelessOreRecipe(null, magicCrystalStack1, new Object[]{crystalFlowerStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/magic_crystal_1")));
        registry.register(new ShapelessOreRecipe(null, magicCrystalStack2, new Object[]{crystalBlockStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/magic_crystal_2")));
        if (Wizardry.settings.firebombIsCraftable) {
            registry.register(new ShapelessOreRecipe(null, firebombStack, new Object[]{bottleStack, gunpowderStack, blazePowderStack, blazePowderStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/fire_bomb")));
        }
        if (Wizardry.settings.poisonBombIsCraftable) {
            registry.register(new ShapelessOreRecipe(null, poisonBombStack, new Object[]{bottleStack, gunpowderStack, spiderEyeStack, spiderEyeStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/poison_bomb")));
        }
        if (Wizardry.settings.smokeBombIsCraftable) {
            registry.register(new ShapelessOreRecipe(null, smokeBombStack, new Object[]{bottleStack, gunpowderStack, coalStack, coalStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/smoke_bomb")));
        }
        if (Wizardry.settings.useAlternateScrollRecipe) {
            registry.register(new ShapelessOreRecipe(null, scrollStack, new Object[]{paperStack, stringStack, magicCrystalStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/blank_scroll")));
        } else {
            registry.register(new ShapelessOreRecipe(null, scrollStack, new Object[]{paperStack, stringStack}).setRegistryName(new ResourceLocation("ebwizardry", "recipes/blank_scroll")));
        }
        for (Element element : Element.values()) {
            for (Tier tier : Tier.values()) {
                ItemStack miscWandStack = new ItemStack(WizardryUtilities.getWand(tier, element), 1, Short.MAX_VALUE);
                registry.register(new ShapelessOreRecipe(null, miscWandStack, new Object[]{miscWandStack, manaFlaskStack}){

                    public boolean func_192399_d() {
                        return true;
                    }
                }.setRegistryName(new ResourceLocation("ebwizardry", "recipes/flask_wand_" + element.getUnlocalisedName() + "_" + tier.getUnlocalisedName())));
            }
        }
        for (Element element : Element.values()) {
            for (EntityEquipmentSlot slot : WizardryUtilities.ARMOUR_SLOTS) {
                ItemStack miscArmourStack = new ItemStack(WizardryUtilities.getArmour(element, slot), 1, Short.MAX_VALUE);
                registry.register(new ShapelessOreRecipe(null, miscArmourStack, new Object[]{miscArmourStack, manaFlaskStack}){

                    public boolean func_192399_d() {
                        return true;
                    }
                }.setRegistryName(new ResourceLocation("ebwizardry", "recipes/flask_armour_" + element.getUnlocalisedName() + "_" + slot.func_188450_d())));
            }
        }
    }
}

