/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemWizardArmour
extends ItemArmor
implements ISpecialArmor {
    public Element element;

    public ItemWizardArmour(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot armourType, Element element) {
        super(material, renderIndex, armourType);
        this.element = element;
        this.func_77637_a(WizardryTabs.WIZARDRY);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("legendary")) {
            tooltip.add("\u00a7d" + I18n.func_135052_a((String)"item.ebwizardry:wizard_armour.legendary", (Object[])new Object[0]));
        }
        if (this.element != null) {
            tooltip.add("\u00a78" + I18n.func_135052_a((String)"item.ebwizardry:wizard_armour.buff", (Object[])new Object[]{"20%", this.element.getDisplayName()}));
        }
        tooltip.add("\u00a79" + I18n.func_135052_a((String)"item.ebwizardry:wizard_armour.mana", (Object[])new Object[]{this.getMaxDamage(stack) - this.getDamage(stack), this.getMaxDamage(stack)}));
    }

    public String func_77653_i(ItemStack stack) {
        return (this.element == null ? "" : this.element.getFormattingCode()) + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("legendary");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armourSlot, ModelBiped _default) {
        ModelBiped model = Wizardry.proxy.getWizardArmourModel();
        if (armourSlot == EntityEquipmentSlot.LEGS) {
            return null;
        }
        if (model != null) {
            ItemStack itemstackL;
            model.field_78116_c.field_78806_j = armourSlot == EntityEquipmentSlot.HEAD;
            model.field_178720_f.field_78806_j = false;
            model.field_78115_e.field_78806_j = armourSlot == EntityEquipmentSlot.CHEST || armourSlot == EntityEquipmentSlot.LEGS;
            model.field_178723_h.field_78806_j = armourSlot == EntityEquipmentSlot.CHEST;
            model.field_178724_i.field_78806_j = armourSlot == EntityEquipmentSlot.CHEST;
            model.field_178721_j.field_78806_j = armourSlot == EntityEquipmentSlot.LEGS || armourSlot == EntityEquipmentSlot.FEET;
            model.field_178722_k.field_78806_j = armourSlot == EntityEquipmentSlot.LEGS || armourSlot == EntityEquipmentSlot.FEET;
            model.field_78117_n = entityLiving.func_70093_af();
            model.field_78093_q = entityLiving.func_184218_aH();
            model.field_78091_s = entityLiving.func_70631_g_();
            boolean leftHanded = entityLiving.func_184591_cq() == EnumHandSide.LEFT;
            ItemStack itemstackR = leftHanded ? entityLiving.func_184592_cb() : entityLiving.func_184614_ca();
            ItemStack itemStack2 = itemstackL = leftHanded ? entityLiving.func_184614_ca() : entityLiving.func_184592_cb();
            if (!itemstackR.func_190926_b()) {
                model.field_187076_m = ModelBiped.ArmPose.ITEM;
                if (entityLiving.func_184605_cv() > 0) {
                    EnumAction enumaction = itemstackR.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        model.field_187076_m = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        model.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!itemstackL.func_190926_b()) {
                model.field_187075_l = ModelBiped.ArmPose.ITEM;
                if (entityLiving.func_184605_cv() > 0) {
                    EnumAction enumaction1 = itemstackL.func_77975_n();
                    if (enumaction1 == EnumAction.BLOCK) {
                        model.field_187075_l = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction1 == EnumAction.BOW) {
                        model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
        }
        return model;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_82150_aj() && !entity.getEntityData().func_74767_n("petrified")) {
            return "ebwizardry:textures/armour/invisible_armour.png";
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return this.element == null ? "ebwizardry:textures/armour/wizard_armour_legs.png" : "ebwizardry:textures/armour/wizard_armour_" + this.element.getUnlocalisedName() + "_legs.png";
        }
        return this.element == null ? "ebwizardry:textures/armour/wizard_armour.png" : "ebwizardry:textures/armour/wizard_armour_" + this.element.getUnlocalisedName() + ".png";
    }

    public boolean func_82789_a(ItemStack stack, ItemStack par2ItemStack) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slotIndex) {
        EntityEquipmentSlot slot = this.getArmorSlotFromIndex(slotIndex);
        if (!source.func_76363_c() && armor.func_77952_i() < armor.func_77958_k()) {
            if (armor.func_77942_o() && armor.func_77978_p().func_74767_n("legendary")) {
                return new ISpecialArmor.ArmorProperties(0, (double)ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(slot) / 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
            }
            return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slotIndex) {
        EntityEquipmentSlot slot = this.getArmorSlotFromIndex(slotIndex);
        if (armor.func_77952_i() < armor.func_77958_k()) {
            if (armor.func_77942_o() && armor.func_77978_p().func_74767_n("legendary")) {
                return ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(slot);
            }
            return this.func_82812_d().func_78044_b(slot);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (stack.func_77952_i() < stack.func_77958_k()) {
            if (stack.func_77952_i() + damage > stack.func_77958_k()) {
                stack.func_77972_a(stack.func_77958_k() - stack.func_77952_i(), entity);
            } else {
                stack.func_77972_a(damage, entity);
            }
        }
    }

    private EntityEquipmentSlot getArmorSlotFromIndex(int slotIndex) {
        EntityEquipmentSlot slot = EntityEquipmentSlot.HEAD;
        for (EntityEquipmentSlot s : WizardryUtilities.ARMOUR_SLOTS) {
            if (s.func_188454_b() != slotIndex) continue;
            slot = s;
        }
        return slot;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_77973_b() instanceof ItemWizardArmour) continue;
                return;
            }
            WizardryAdvancementTriggers.armour_set.triggerFor(player);
        }
    }
}

