/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.event;

import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public abstract class SpellCastEvent
extends LivingEvent {
    private final Spell spell;
    private final SpellModifiers modifiers;
    private final Source source;

    public SpellCastEvent(EntityLivingBase caster, Spell spell, SpellModifiers modifiers, Source source) {
        super(caster);
        this.spell = spell;
        this.modifiers = modifiers;
        this.source = source;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellModifiers getModifiers() {
        return this.modifiers;
    }

    public Source getSource() {
        return this.source;
    }

    @Cancelable
    public static class Tick
    extends SpellCastEvent {
        private final int count;

        public Tick(EntityLivingBase caster, Spell spell, SpellModifiers modifiers, Source source, int count) {
            super(caster, spell, modifiers, source);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class Post
    extends SpellCastEvent {
        public Post(EntityLivingBase caster, Spell spell, SpellModifiers modifiers, Source source) {
            super(caster, spell, modifiers, source);
        }
    }

    @Cancelable
    public static class Pre
    extends SpellCastEvent {
        public Pre(EntityLivingBase caster, Spell spell, SpellModifiers modifiers, Source source) {
            super(caster, spell, modifiers, source);
        }
    }

    public static enum Source {
        WAND,
        SCROLL,
        COMMAND,
        NPC,
        OTHER;

    }
}

