/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemSpectralBow;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketControlInput;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Flight;
import electroblob.wizardry.spell.ShadowWard;
import electroblob.wizardry.spell.Shield;
import electroblob.wizardry.tileentity.ContainerArcaneWorkbench;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryUtilities;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class WizardryClientEventHandler {
    private static final ResourceLocation shieldTexture = new ResourceLocation("ebwizardry", "textures/entity/shield.png");
    private static final ResourceLocation wingTexture = new ResourceLocation("ebwizardry", "textures/entity/wing.png");
    private static final ResourceLocation shadowWardTexture = new ResourceLocation("ebwizardry", "textures/entity/shadow_ward.png");
    private static final ResourceLocation sixthSenseTexture = new ResourceLocation("ebwizardry", "textures/entity/sixth_sense.png");
    private static final ResourceLocation sixthSenseOverlayTexture = new ResourceLocation("ebwizardry", "textures/gui/sixth_sense_overlay.png");
    private static final ResourceLocation frostOverlayTexture = new ResourceLocation("ebwizardry", "textures/gui/frost_overlay.png");
    private static final ResourceLocation pointerTexture = new ResourceLocation("ebwizardry", "textures/entity/pointer.png");
    private static final ResourceLocation targetPointerTexture = new ResourceLocation("ebwizardry", "textures/entity/target_pointer.png");
    private static final Field ITEM_RENDERER = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"itemRender", "field_146296_j"});

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(ContainerArcaneWorkbench.EMPTY_SLOT_CRYSTAL);
        event.getMap().func_174942_a(ContainerArcaneWorkbench.EMPTY_SLOT_UPGRADE);
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack wand = player.func_184614_ca();
        if (!(wand.func_77973_b() instanceof ItemWand) && !((wand = player.func_184592_cb()).func_77973_b() instanceof ItemWand)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71415_G && !wand.func_190926_b() && event.getDwheel() != 0 && player.func_70093_af() && Wizardry.settings.enableShiftScrolling) {
            event.setCanceled(true);
            if (event.getDwheel() > 0) {
                PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.PREVIOUS_SPELL_KEY);
                WizardryPacketHandler.net.sendToServer((IMessage)msg);
            } else if (event.getDwheel() < 0) {
                PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.NEXT_SPELL_KEY);
                WizardryPacketHandler.net.sendToServer((IMessage)msg);
            }
        }
    }

    @SubscribeEvent
    public static void onFOVUpdateEvent(FOVUpdateEvent event) {
        if (event.getEntity().func_184587_cr() && event.getEntity().func_184607_cu().func_77973_b() instanceof ItemSpectralBow) {
            int maxUseTicks = event.getEntity().func_184612_cw();
            float maxUseSeconds = (float)maxUseTicks / 20.0f;
            maxUseSeconds = maxUseSeconds > 1.0f ? 1.0f : (maxUseSeconds *= maxUseSeconds);
            event.setNewfov(event.getFov() * 1.0f - maxUseSeconds * 0.15f);
        }
    }

    @SubscribeEvent
    public static void onGuiDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof GuiMerchant) {
            GuiMerchant gui = (GuiMerchant)event.getGuiContainer();
            if (gui.field_147002_h.func_75139_a(0).func_75211_c().func_77973_b() == WizardryItems.spell_book || gui.field_147002_h.func_75139_a(1).func_75211_c().func_77973_b() == WizardryItems.spell_book) {
                for (MerchantRecipe trade : gui.func_147035_g().func_70934_b((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    if (trade.func_77394_a().func_77973_b() != WizardryItems.spell_book || !trade.func_77396_b().func_190926_b()) continue;
                    Slot slot = gui.field_147002_h.func_75139_a(2);
                    WizardryClientEventHandler.renderItemAndTooltip((GuiContainer)gui, trade.func_77397_d(), slot.field_75223_e, slot.field_75221_f, event.getMouseX(), event.getMouseY(), gui.getSlotUnderMouse() == slot);
                }
            }
        }
    }

    private static void renderItemAndTooltip(GuiContainer gui, ItemStack stack, int x, int y, int mouseX, int mouseY, boolean tooltip) {
        try {
            RenderItem renderItem = (RenderItem)ITEM_RENDERER.get(gui);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GL11.glEnable((int)2903);
            GlStateManager.func_179145_e();
            renderItem.field_77023_b = 100.0f;
            if (!stack.func_190926_b()) {
                renderItem.func_180450_b(stack, x, y);
                renderItem.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, x, y);
                if (tooltip) {
                    gui.func_146283_a(gui.func_191927_a(stack), mouseX + gui.getXSize() / 2 - gui.field_146294_l / 2, mouseY + gui.getYSize() / 2 - gui.field_146295_m / 2);
                }
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerEvent(RenderPlayerEvent.Post event) {
        WizardryClientEventHandler.renderShieldIfActive(event.getEntityPlayer());
        WizardryClientEventHandler.renderWingsIfActive(event.getEntityPlayer(), event.getPartialRenderTick());
        WizardryClientEventHandler.renderShadowWardIfActive(event.getEntityPlayer());
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            WizardryClientEventHandler.renderShieldFirstPerson((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            WizardryClientEventHandler.renderShadowWardFirstPerson((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent.Post<EntityLivingBase> event) {
        float yaw;
        BufferBuilder buffer;
        Tessellator tessellator;
        Minecraft mc = Minecraft.func_71410_x();
        WizardData properties = WizardData.get((EntityPlayer)mc.field_71439_g);
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace((World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g, 16.0);
        RenderManager renderManager = event.getRenderer().func_177068_d();
        ItemStack wand = mc.field_71439_g.func_184614_ca();
        if (!(wand.func_77973_b() instanceof ItemWand)) {
            wand = mc.field_71439_g.func_184592_cb();
        }
        if (mc.field_71439_g.func_70093_af() && wand.func_77973_b() instanceof ItemWand && rayTrace != null && !(event.getEntity() instanceof EntityArmorStand) && rayTrace.field_72308_g == event.getEntity() && properties != null && properties.selectedMinion != null) {
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2929);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O + 0.5), (double)event.getZ());
            yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            mc.field_71446_o.func_110577_a(targetPointerTexture);
            buffer.func_181662_b(-0.2, 0.24, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.2, 0.24, 0.0).func_187315_a(0.5625, 0.0).func_181675_d();
            buffer.func_181662_b(0.2, -0.24, 0.0).func_187315_a(0.5625, 0.6875).func_181675_d();
            buffer.func_181662_b(-0.2, -0.24, 0.0).func_187315_a(0.0, 0.6875).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GL11.glEnable((int)2929);
            GlStateManager.func_179121_F();
        }
        if (properties != null && properties.selectedMinion != null && properties.selectedMinion.get() == event.getEntity()) {
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2929);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O + 0.5), (double)event.getZ());
            yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            mc.field_71446_o.func_110577_a(pointerTexture);
            buffer.func_181662_b(-0.2, 0.24, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.2, 0.24, 0.0).func_187315_a(0.5625, 0.0).func_181675_d();
            buffer.func_181662_b(0.2, -0.24, 0.0).func_187315_a(0.5625, 0.6875).func_181675_d();
            buffer.func_181662_b(-0.2, -0.24, 0.0).func_187315_a(0.0, 0.6875).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GL11.glEnable((int)2929);
            GlStateManager.func_179121_F();
        }
        if (mc.field_71439_g.func_70644_a(WizardryPotions.sixth_sense) && !(event.getEntity() instanceof EntityArmorStand) && event.getEntity() != mc.field_71439_g && mc.field_71439_g.func_70660_b(WizardryPotions.sixth_sense) != null && event.getEntity().func_70032_d((Entity)mc.field_71439_g) < 20.0f * (1.0f + (float)mc.field_71439_g.func_70660_b(WizardryPotions.sixth_sense).func_76458_c() * 0.25f)) {
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glDisable((int)2929);
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O * 0.6), (double)event.getZ());
            yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            mc.field_71446_o.func_110577_a(sixthSenseTexture);
            buffer.func_181662_b(-0.6, 0.6, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.6, 0.6, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.6, -0.6, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-0.6, -0.6, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GL11.glEnable((int)2929);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        BufferBuilder buffer;
        Tessellator tessellator;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.sixth_sense)) {
            GlStateManager.func_179094_E();
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(sixthSenseOverlayTexture);
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, (double)event.getResolution().func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)event.getResolution().func_78326_a(), (double)event.getResolution().func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)event.getResolution().func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.frost)) {
            GlStateManager.func_179094_E();
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(frostOverlayTexture);
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, (double)event.getResolution().func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)event.getResolution().func_78326_a(), (double)event.getResolution().func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)event.getResolution().func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    private static void renderShadowWardFirstPerson(EntityPlayer entityplayer) {
        ItemStack wand = entityplayer.func_184607_cu();
        if (WizardData.get(entityplayer) != null && WizardData.get(entityplayer).currentlyCasting() instanceof ShadowWard || entityplayer.func_184587_cr() && wand.func_77952_i() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof ShadowWard) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179140_f();
            GlStateManager.func_179118_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179137_b((double)0.0, (double)1.2, (double)0.0);
            GlStateManager.func_179114_b((float)(-entityplayer.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)entityplayer.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(shadowWardTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)1.2);
            GlStateManager.func_179114_b((float)(entityplayer.field_70170_p.func_72820_D() * -2L), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderShadowWardIfActive(EntityPlayer entityplayer) {
        ItemStack wand = entityplayer.func_184607_cu();
        if (WizardData.get(entityplayer).currentlyCasting() instanceof ShadowWard || entityplayer.func_184587_cr() && wand.func_77952_i() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof ShadowWard) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-entityplayer.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(shadowWardTexture);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179137_b((double)0.0, (double)1.2, (double)0.0);
            GlStateManager.func_179114_b((float)(entityplayer.field_70170_p.func_72820_D() * -2L), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderWingsIfActive(EntityPlayer entityplayer, float partialTickTime) {
        ItemStack wand = entityplayer.func_184607_cu();
        if (WizardData.get(entityplayer).currentlyCasting() instanceof Flight || entityplayer.func_184587_cr() && wand.func_77952_i() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof Flight) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179114_b((float)(-entityplayer.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(wingTexture);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.1, (double)0.4, (double)-0.15);
            GlStateManager.func_179114_b((float)(20.0f + 20.0f * (float)Math.sin((double)entityplayer.field_70170_p.func_72820_D() * 0.3)), (float)0.0f, (float)1.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 2.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(2.0, 2.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(2.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 2.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(2.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(2.0, 2.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)-0.1, (double)0.4, (double)-0.15);
            GlStateManager.func_179114_b((float)(-200.0f - 20.0f * (float)Math.sin((double)entityplayer.field_70170_p.func_72820_D() * 0.3)), (float)0.0f, (float)1.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 2.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(2.0, 2.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(2.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 2.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(2.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(2.0, 2.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderShieldFirstPerson(EntityPlayer entityplayer) {
        ItemStack wand = entityplayer.func_184607_cu();
        if (WizardData.get(entityplayer) != null && WizardData.get((EntityPlayer)entityplayer).shield != null && (WizardData.get(entityplayer).currentlyCasting() instanceof Shield || entityplayer.func_184587_cr() && wand.func_77952_i() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof Shield)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)770);
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179137_b((double)0.0, (double)1.4, (double)0.0);
            GlStateManager.func_179114_b((float)(-entityplayer.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)entityplayer.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.8);
            Tessellator tessellator = Tessellator.func_178181_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(shieldTexture);
            WizardryClientEventHandler.renderShield(tessellator);
            GlStateManager.func_179145_e();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderShieldIfActive(EntityPlayer entityplayer) {
        ItemStack wand = entityplayer.func_184607_cu();
        if (WizardData.get((EntityPlayer)entityplayer).shield != null && (WizardData.get(entityplayer).currentlyCasting() instanceof Shield || entityplayer.func_184587_cr() && wand.func_77952_i() < wand.func_77958_k() && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof Shield)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)770);
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179137_b((double)0.0, (double)1.3, (double)0.0);
            GlStateManager.func_179114_b((float)(-entityplayer.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.8);
            Tessellator tessellator = Tessellator.func_178181_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(shieldTexture);
            WizardryClientEventHandler.renderShield(tessellator);
            GlStateManager.func_179145_e();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderShield(Tessellator tessellator) {
        BufferBuilder buffer = tessellator.func_178180_c();
        double widthOuter = 0.6;
        double heightOuter = 0.7;
        double widthInner = 0.3;
        double heightInner = 0.4;
        double depth = 0.2;
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(-widthOuter, heightInner, -depth).func_187315_a(0.0, 0.2).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, heightInner, 0.0).func_187315_a(0.2, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, heightOuter, -depth).func_187315_a(0.2, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, heightInner, 0.0).func_187315_a(0.2, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(widthInner, heightOuter, -depth).func_187315_a(0.8, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(widthInner, heightInner, 0.0).func_187315_a(0.8, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(widthOuter, heightInner, -depth).func_187315_a(1.0, 0.2).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(widthInner, heightInner, 0.0).func_187315_a(0.8, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(widthOuter, -heightInner, -depth).func_187315_a(1.0, 0.8).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(widthInner, -heightInner, 0.0).func_187315_a(0.8, 0.8).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(widthInner, -heightOuter, -depth).func_187315_a(0.8, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(widthInner, -heightInner, 0.0).func_187315_a(0.8, 0.8).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, -heightOuter, -depth).func_187315_a(0.2, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, -heightInner, 0.0).func_187315_a(0.2, 0.8).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(-widthOuter, -heightInner, -depth).func_187315_a(0.0, 0.8).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, -heightInner, 0.0).func_187315_a(0.2, 0.8).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(-widthOuter, heightInner, -depth).func_187315_a(0.0, 0.2).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, heightInner, 0.0).func_187315_a(0.2, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(-widthInner, heightInner, 0.0).func_187315_a(0.2, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(widthInner, heightInner, 0.0).func_187315_a(0.8, 0.2).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(-widthInner, -heightInner, 0.0).func_187315_a(0.2, 0.8).func_181669_b(200, 200, 255, 255).func_181675_d();
        buffer.func_181662_b(widthInner, -heightInner, 0.0).func_187315_a(0.8, 0.8).func_181669_b(200, 200, 255, 255).func_181675_d();
        tessellator.func_78381_a();
    }
}

