/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.Settings;
import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiSpellDisplay
extends Gui {
    private Minecraft mc;
    private static final ResourceLocation hudTexture = new ResourceLocation("ebwizardry", "textures/gui/spell_hud.png");

    public GuiSpellDisplay(Minecraft par1Minecraft) {
        this.mc = par1Minecraft;
    }

    @SubscribeEvent
    public void draw(RenderGameOverlayEvent event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        ItemStack wand = player.func_184614_ca();
        if (!(wand.func_77973_b() instanceof ItemWand) && !((wand = player.func_184592_cb()).func_77973_b() instanceof ItemWand)) {
            return;
        }
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        Spell spell = WandHelper.getCurrentSpell(wand);
        int cooldown = WandHelper.getCurrentCooldown(wand);
        float cooldownMultiplier = 1.0f - (float)WandHelper.getUpgradeLevel(wand, WizardryItems.cooldown_upgrade) * 0.15f;
        if (player.func_70644_a(WizardryPotions.font_of_mana)) {
            cooldownMultiplier /= (float)(2 + player.func_70660_b(WizardryPotions.font_of_mana).func_76458_c());
        }
        int left = 0;
        int top = 0;
        boolean mirror = false;
        if (Wizardry.settings.spellHUDPosition == Settings.GuiPosition.BOTTOM_LEFT) {
            left = 0;
            top = height - 36;
        } else if (Wizardry.settings.spellHUDPosition == Settings.GuiPosition.TOP_LEFT) {
            left = 0;
            top = 0;
        } else if (Wizardry.settings.spellHUDPosition == Settings.GuiPosition.TOP_RIGHT) {
            left = width - 128;
            top = 0;
            mirror = true;
        } else if (Wizardry.settings.spellHUDPosition == Settings.GuiPosition.BOTTOM_RIGHT) {
            left = width - 128;
            top = height - 36;
            mirror = true;
        }
        boolean discovered = true;
        if (!player.field_71075_bZ.field_75098_d && WizardData.get((EntityPlayer)player) != null) {
            discovered = WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            String colour;
            String string = colour = cooldown > 0 || player.func_70644_a(WizardryPotions.arcane_jammer) ? "\u00a78" : spell.element.getFormattingCode();
            if (!discovered) {
                colour = "\u00a79";
            }
            String spellName = discovered ? spell.getDisplayName() : SpellGlyphData.getGlyphName(spell, player.field_70170_p);
            FontRenderer font = discovered ? this.mc.field_71466_p : this.mc.field_71464_q;
            int maxWidth = 90;
            if (font.func_78256_a(spellName) <= maxWidth) {
                font.func_175063_a(colour + spellName, mirror ? (float)(left + 5) : (float)(left + 41), (float)(top + 13), -1);
            } else {
                int lineNumber = 0;
                List lines = font.func_78271_c(spellName, maxWidth);
                for (Object line : lines) {
                    if (line instanceof String) {
                        font.func_175063_a(colour + (String)line, mirror ? (float)(left + 5) : (float)(left + 41), (float)(top + 6 + 11 * lineNumber), -1);
                    }
                    ++lineNumber;
                }
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            GlStateManager.func_179123_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(hudTexture);
            this.func_73729_b(left, top, 0, mirror ? 36 : 0, 128, 36);
            if (cooldown > 0) {
                this.func_73729_b(mirror ? left + 5 : left + 41, top + 28, 128, 6, 82, 6);
                int l = (int)((double)((float)spell.cooldown * cooldownMultiplier - (float)cooldown) / (double)((float)spell.cooldown * cooldownMultiplier) * 82.0);
                this.func_73729_b(mirror ? left + 5 : left + 41, top + 28, 128, 0, l, 6);
            }
            this.mc.field_71446_o.func_110577_a(discovered ? spell.getIcon() : Spells.none.getIcon());
            WizardryUtilities.drawTexturedRect(mirror ? left + 94 : left + 2, top + 2, 0, 0, 32, 32, 32, 32);
            GlStateManager.func_179099_b();
        }
    }
}

