/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.CommonProxy;
import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.GuiSpellDisplay;
import electroblob.wizardry.client.GuiWizardHandbook;
import electroblob.wizardry.client.MixedFontRenderer;
import electroblob.wizardry.client.MovingSoundEntity;
import electroblob.wizardry.client.model.ModelWizardArmour;
import electroblob.wizardry.client.particle.ParticleBlizzard;
import electroblob.wizardry.client.particle.ParticleDarkMagic;
import electroblob.wizardry.client.particle.ParticleDust;
import electroblob.wizardry.client.particle.ParticleGiantBubble;
import electroblob.wizardry.client.particle.ParticleIce;
import electroblob.wizardry.client.particle.ParticleLeaf;
import electroblob.wizardry.client.particle.ParticleMagicFlame;
import electroblob.wizardry.client.particle.ParticlePath;
import electroblob.wizardry.client.particle.ParticleRotatingSparkle;
import electroblob.wizardry.client.particle.ParticleSnow;
import electroblob.wizardry.client.particle.ParticleSpark;
import electroblob.wizardry.client.particle.ParticleSparkle;
import electroblob.wizardry.client.particle.ParticleTornado;
import electroblob.wizardry.client.renderer.LayerStone;
import electroblob.wizardry.client.renderer.RenderArc;
import electroblob.wizardry.client.renderer.RenderArcaneWorkbench;
import electroblob.wizardry.client.renderer.RenderBlackHole;
import electroblob.wizardry.client.renderer.RenderBlank;
import electroblob.wizardry.client.renderer.RenderBubble;
import electroblob.wizardry.client.renderer.RenderDecay;
import electroblob.wizardry.client.renderer.RenderDecoy;
import electroblob.wizardry.client.renderer.RenderEvilWizard;
import electroblob.wizardry.client.renderer.RenderFireRing;
import electroblob.wizardry.client.renderer.RenderForceArrow;
import electroblob.wizardry.client.renderer.RenderHammer;
import electroblob.wizardry.client.renderer.RenderIceGiant;
import electroblob.wizardry.client.renderer.RenderIceSpike;
import electroblob.wizardry.client.renderer.RenderLightningDisc;
import electroblob.wizardry.client.renderer.RenderLightningPulse;
import electroblob.wizardry.client.renderer.RenderMagicArrow;
import electroblob.wizardry.client.renderer.RenderMagicLight;
import electroblob.wizardry.client.renderer.RenderPhoenix;
import electroblob.wizardry.client.renderer.RenderProjectile;
import electroblob.wizardry.client.renderer.RenderSigil;
import electroblob.wizardry.client.renderer.RenderSpiritHorse;
import electroblob.wizardry.client.renderer.RenderSpiritWolf;
import electroblob.wizardry.client.renderer.RenderStatue;
import electroblob.wizardry.client.renderer.RenderWizard;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.entity.construct.EntityForcefield;
import electroblob.wizardry.entity.construct.EntityFrostSigil;
import electroblob.wizardry.entity.construct.EntityHailstorm;
import electroblob.wizardry.entity.construct.EntityHammer;
import electroblob.wizardry.entity.construct.EntityHealAura;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.entity.construct.EntityLightningPulse;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.construct.EntityTornado;
import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityPhoenix;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityDarknessOrb;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityFirebolt;
import electroblob.wizardry.entity.projectile.EntityFirebomb;
import electroblob.wizardry.entity.projectile.EntityForceArrow;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceCharge;
import electroblob.wizardry.entity.projectile.EntityIceLance;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.entity.projectile.EntityLightningArrow;
import electroblob.wizardry.entity.projectile.EntityLightningDisc;
import electroblob.wizardry.entity.projectile.EntityMagicMissile;
import electroblob.wizardry.entity.projectile.EntityPoisonBomb;
import electroblob.wizardry.entity.projectile.EntitySmokeBomb;
import electroblob.wizardry.entity.projectile.EntitySpark;
import electroblob.wizardry.entity.projectile.EntitySparkBomb;
import electroblob.wizardry.entity.projectile.EntityThunderbolt;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketCastContinuousSpell;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.PacketClairvoyance;
import electroblob.wizardry.packet.PacketGlyphData;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.PacketPlayerSync;
import electroblob.wizardry.packet.PacketTransportation;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Clairvoyance;
import electroblob.wizardry.spell.None;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.tileentity.TileEntityMagicLight;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryParticleType;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.RenderBlaze;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ClientProxy
extends CommonProxy {
    public static MixedFontRenderer mixedFontRenderer;
    public static final KeyBinding NEXT_SPELL;
    public static final KeyBinding PREVIOUS_SPELL;
    public static final ModelBiped WIZARD_ARMOUR_MODEL;
    private static final ResourceLocation ICE_WRAITH_TEXTURE;
    private static final ResourceLocation LIGHTNING_WRAITH_TEXTURE;
    public static RenderStatue renderStatue;

    @Override
    public ModelBiped getWizardArmourModel() {
        return WIZARD_ARMOUR_MODEL;
    }

    @Override
    public void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)NEXT_SPELL);
        ClientRegistry.registerKeyBinding((KeyBinding)PREVIOUS_SPELL);
    }

    @Override
    public void registerSpellHUD() {
        MinecraftForge.EVENT_BUS.register((Object)new GuiSpellDisplay(Minecraft.func_71410_x()));
    }

    @Override
    public void initGuiBits() {
        mixedFontRenderer = new MixedFontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        GuiWizardHandbook.initDisplayRecipes();
    }

    @Override
    public void setToNumberSliderEntry(Property property) {
        property.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
    }

    @Override
    public World getTheWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void playMovingSound(Entity entity, SoundEvent sound, float volume, float pitch, boolean repeat) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundEntity(entity, sound, volume, pitch, repeat));
    }

    @Override
    public FontRenderer getFontRenderer(ItemStack stack) {
        Spell spell = Spells.none;
        if (stack.func_77973_b() instanceof ItemWand) {
            spell = WandHelper.getCurrentSpell(stack);
        } else if (stack.func_77973_b() instanceof ItemSpellBook || stack.func_77973_b() instanceof ItemScroll) {
            spell = Spell.get(stack.func_77952_i());
        }
        if (Minecraft.func_71410_x().field_71439_g != null && Wizardry.settings.discoveryMode && WizardData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g) != null && !Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && !WizardData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).hasSpellBeenDiscovered(spell)) {
            return mixedFontRenderer;
        }
        return null;
    }

    @Override
    public String getScrollDisplayName(ItemStack scroll) {
        Spell spell = Spell.get(scroll.func_77952_i());
        if (spell.isContinuous) {
            spell = Spells.none;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean discovered = true;
        if (player != null && Wizardry.settings.discoveryMode && !player.field_71075_bZ.field_75098_d && WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
            discovered = false;
        }
        if (discovered) {
            return I18n.func_135052_a((String)"item.ebwizardry:scroll.name", (Object[])new Object[]{spell.getDisplayName()}).trim();
        }
        return I18n.func_135052_a((String)"item.ebwizardry:scroll.undiscovered.name", (Object[])new Object[]{"#" + SpellGlyphData.getGlyphName(spell, player.field_70170_p) + "#"}).trim();
    }

    @Override
    public double getConjuredBowDurability(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184607_cu() == stack) {
            return (double)(stack.func_77952_i() + player.func_184612_cw()) / (double)stack.func_77958_k();
        }
        return super.getConjuredBowDurability(stack);
    }

    @Override
    public void spawnParticle(WizardryParticleType type, World world, double x, double y, double z, double velX, double velY, double velZ, int maxAge, float r, float g, float b, boolean doGravity, double radius) {
        if (type != WizardryParticleType.MAGIC_FIRE) {
            r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        }
        g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        b = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        switch (type) {
            case BLIZZARD: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBlizzard(world, maxAge, x, z, radius, y));
                break;
            }
            case BRIGHT_DUST: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleDust(world, x, y, z, velX, velY, velZ, r, g, b, false));
                break;
            }
            case DARK_MAGIC: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleDarkMagic(world, x, y, z, velX, velY, velZ, r, g, b));
                break;
            }
            case DUST: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleDust(world, x, y, z, velX, velY, velZ, r, g, b, true));
                break;
            }
            case ICE: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleIce(world, x, y, z, velX, velY, velZ, maxAge));
                break;
            }
            case LEAF: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleLeaf(world, x, y, z, velX, velY, velZ, maxAge));
                break;
            }
            case MAGIC_BUBBLE: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleGiantBubble(world, x, y, z, velX, velY, velZ));
                break;
            }
            case MAGIC_FIRE: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleMagicFlame(world, x, y, z, velX, velY, velZ, maxAge, r == 0.0f ? 1.0f + world.field_73012_v.nextFloat() : r));
                break;
            }
            case PATH: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticlePath(world, x, y, z, velX, velY, velZ, r, g, b, maxAge));
                break;
            }
            case SNOW: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSnow(world, x, y, z, velX, velY, velZ));
                break;
            }
            case SPARK: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSpark(world, x, y, z, velX, velY, velZ));
                break;
            }
            case SPARKLE: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSparkle(world, x, y, z, velX, velY, velZ, r, g, b, maxAge, doGravity));
                break;
            }
            case SPARKLE_ROTATING: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleRotatingSparkle(world, maxAge, x, z, radius, y, r, g, b));
                break;
            }
        }
    }

    @Override
    public void spawnTornadoParticle(World world, double x, double y, double z, double velX, double velZ, double radius, int maxAge, IBlockState block, BlockPos pos) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTornado(world, maxAge, x, z, radius, y, velX, velZ, block).func_174846_a(pos));
    }

    @Override
    public void handleCastSpellPacket(PacketCastSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Spell spell = Spell.get(message.spellID);
        if (caster instanceof EntityPlayer) {
            ((EntityPlayer)caster).func_184598_c(message.hand);
            spell.cast((World)world, (EntityPlayer)caster, message.hand, 0, message.modifiers);
            SpellCastEvent.Source source = SpellCastEvent.Source.OTHER;
            Item item = ((EntityPlayer)caster).func_184586_b(message.hand).func_77973_b();
            if (item instanceof ItemWand) {
                source = SpellCastEvent.Source.WAND;
            } else if (item instanceof ItemScroll) {
                source = SpellCastEvent.Source.SCROLL;
            }
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)((EntityPlayer)caster), spell, message.modifiers, source));
        } else {
            Wizardry.logger.warn("Recieved a PacketCastSpell, but the caster ID was not the ID of a player");
        }
    }

    @Override
    public void handleCastContinuousSpellPacket(PacketCastContinuousSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Spell spell = Spell.get(message.spellID);
        if (caster instanceof EntityPlayer) {
            WizardData data = WizardData.get((EntityPlayer)caster);
            if (data != null) {
                if (data.isCasting()) {
                    WizardData.get((EntityPlayer)caster).stopCastingContinuousSpell();
                } else {
                    WizardData.get((EntityPlayer)caster).startCastingContinuousSpell(spell, message.modifiers);
                }
            }
        } else {
            Wizardry.logger.warn("Recieved a PacketCastContinuousSpell, but the caster ID was not the ID of a player");
        }
    }

    @Override
    public void handleNPCCastSpellPacket(PacketNPCCastSpell.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Entity target = message.targetID == -1 ? null : world.func_73045_a(message.targetID);
        Spell spell = Spell.get(message.spellID);
        if (caster instanceof EntityLiving) {
            if (target instanceof EntityLivingBase) {
                spell.cast((World)world, (EntityLiving)caster, message.hand, 0, (EntityLivingBase)target, message.modifiers);
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post((EntityLivingBase)((EntityLiving)caster), spell, message.modifiers, SpellCastEvent.Source.NPC));
            }
            if (caster instanceof ISpellCaster && (spell.isContinuous || spell instanceof None)) {
                ((ISpellCaster)caster).setContinuousSpell(spell);
                ((EntityLiving)caster).func_70624_b((EntityLivingBase)target);
            }
        } else {
            Wizardry.logger.warn("Recieved a PacketNPCCastSpell, but the caster ID was not the ID of an EntityLiving");
        }
    }

    @Override
    public void handleTransportationPacket(PacketTransportation.Message message) {
        double z;
        double y;
        double x;
        double angle;
        double radius;
        int i;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        caster.func_184185_a(SoundEvents.field_187812_eh, 1.0f, 1.0f);
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            x = caster.field_70165_t + radius * Math.cos(angle);
            y = caster.func_174813_aQ().field_72338_b + world.field_73012_v.nextDouble() * 2.0;
            z = caster.field_70161_v + radius * Math.sin(angle);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSparkle((World)world, x, y, z, 0.0, 0.02, 0.0, 0.6f, 1.0f, 0.6f, 80 + world.field_73012_v.nextInt(10)));
        }
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            x = caster.field_70165_t + radius * Math.cos(angle);
            y = caster.func_174813_aQ().field_72338_b + world.field_73012_v.nextDouble() * 2.0;
            z = caster.field_70161_v + radius * Math.sin(angle);
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, x, y, z, 0.0, 0.02, 0.0, new int[0]);
        }
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            x = caster.field_70165_t + radius * Math.cos(angle);
            y = caster.func_174813_aQ().field_72338_b + world.field_73012_v.nextDouble() * 2.0;
            z = caster.field_70161_v + radius * Math.sin(angle);
            world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x, y, z, 0.0, 0.02, 0.0, new int[0]);
        }
    }

    @Override
    public void handlePlayerSyncPacket(PacketPlayerSync.Message message) {
        WizardData properties = WizardData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (properties != null) {
            Entity entity;
            properties.spellsDiscovered = message.spellsDiscovered;
            properties.selectedMinion = message.selectedMinionID == -1 ? null : ((entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.selectedMinionID)) instanceof ISummonedCreature ? new WeakReference<ISummonedCreature>((ISummonedCreature)entity) : null);
        }
    }

    @Override
    public void handleGlyphDataPacket(PacketGlyphData.Message message) {
        SpellGlyphData data = SpellGlyphData.get((World)Minecraft.func_71410_x().field_71441_e);
        data.randomNames = new HashMap<Spell, String>();
        data.randomDescriptions = new HashMap<Spell, String>();
        for (Spell spell : Spell.getSpells(Spell.allSpells)) {
            data.randomNames.put(spell, message.names.get(spell.id() - 1));
            data.randomDescriptions.put(spell, message.descriptions.get(spell.id() - 1));
        }
    }

    @Override
    public void handleClairvoyancePacket(PacketClairvoyance.Message message) {
        Clairvoyance.spawnPathPaticles((World)Minecraft.func_71410_x().field_71441_e, message.path, message.durationMultiplier);
    }

    @Override
    public void initialiseLayers() {
        LayerStone.initialiseLayers();
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningWraith.class, manager -> new RenderBlaze(manager){

            protected ResourceLocation func_110775_a(EntityBlaze entity) {
                return LIGHTNING_WRAITH_TEXTURE;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityIceWraith.class, manager -> new RenderBlaze(manager){

            protected ResourceLocation func_110775_a(EntityBlaze entity) {
                return ICE_WRAITH_TEXTURE;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityIceGiant.class, RenderIceGiant::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPhoenix.class, RenderPhoenix::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicMissile.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/magic_missile.png"), false, 8.0, 4.0, 16, 9, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceShard.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/ice_shard.png"), false, 8.0, 2.0, 16, 5, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningArrow.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_arrow.png"), true, 8.0, 2.0, 16, 5, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityDart.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/dart.png"), false, 8.0, 2.0, 16, 5, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceLance.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/ice_lance.png"), false, 16.0, 3.0, 22, 5, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityForceArrow.class, RenderForceArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiritWolf.class, manager -> new RenderSpiritWolf(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiritHorse.class, manager -> new RenderSpiritHorse(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityWizard.class, RenderWizard::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEvilWizard.class, RenderEvilWizard::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDecoy.class, RenderDecoy::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySparkBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/entity/spark_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityFirebomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/firebomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityPoisonBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/poison_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceCharge.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/entity/ice_charge.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityForceOrb.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ebwizardry", "textures/entity/force_orb.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpark.class, manager -> new RenderProjectile(manager, 0.4f, new ResourceLocation("ebwizardry", "textures/entity/spark.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityDarknessOrb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/entity/darkness_orb.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityFirebolt.class, manager -> new RenderProjectile(manager, 0.2f, new ResourceLocation("ebwizardry", "textures/entity/firebolt.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningDisc.class, manager -> new RenderLightningDisc(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_sigil.png"), 2.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntitySmokeBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ebwizardry", "textures/items/smoke_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityArc.class, RenderArc::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlackHole.class, RenderBlackHole::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShield.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBubble.class, RenderBubble::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHammer.class, RenderHammer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityIceSpike.class, RenderIceSpike::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlizzard.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTornado.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityArrowRain.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShadowWraith.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityForcefield.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityThunderbolt.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStormElemental.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEarthquake.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHailstorm.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHealAura.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/healing_aura.png"), 5.0f, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/fire_sigil.png"), 2.0f, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityFrostSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/frost_sigil.png"), 2.0f, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_sigil.png"), 2.0f, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireRing.class, manager -> new RenderFireRing(manager, new ResourceLocation("ebwizardry", "textures/entity/ring_of_fire.png"), 5.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityDecay.class, RenderDecay::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningPulse.class, manager -> new RenderLightningPulse(manager, 8.0f));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArcaneWorkbench.class, (TileEntitySpecialRenderer)new RenderArcaneWorkbench());
        renderStatue = new RenderStatue();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStatue.class, (TileEntitySpecialRenderer)renderStatue);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMagicLight.class, (TileEntitySpecialRenderer)new RenderMagicLight());
    }

    static {
        NEXT_SPELL = new KeyBinding("key.ebwizardry.next_spell", 49, "key.categories.ebwizardry");
        PREVIOUS_SPELL = new KeyBinding("key.ebwizardry.previous_spell", 48, "key.categories.ebwizardry");
        WIZARD_ARMOUR_MODEL = new ModelWizardArmour(0.75f);
        ICE_WRAITH_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/ice_wraith.png");
        LIGHTNING_WRAITH_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/lightning_wraith.png");
    }
}

