/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreIngredient;
import vazkii.arl.interf.IRecipeGrouped;
import vazkii.arl.recipe.ModRecipe;
import vazkii.arl.recipe.MultiRecipe;
import vazkii.arl.util.ProxyRegistry;

public final class RecipeHandler {
    private static final List<ResourceLocation> usedNames = new ArrayList<ResourceLocation>();

    public static void addOreDictRecipe(ItemStack output, Object ... inputs) {
        RecipeHandler.addShapedRecipe(null, output, inputs);
    }

    public static void addShapelessOreDictRecipe(ItemStack output, Object ... inputs) {
        RecipeHandler.addShapelessRecipe(null, output, inputs);
    }

    public static void addOreDictRecipe(MultiRecipe multi, ItemStack output, Object ... inputs) {
        RecipeHandler.addShapedRecipe(multi, output, inputs);
    }

    public static void addShapelessOreDictRecipe(MultiRecipe multi, ItemStack output, Object ... inputs) {
        RecipeHandler.addShapelessRecipe(multi, output, inputs);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... inputs) {
        RecipeHandler.addShapelessRecipe(null, output, inputs);
    }

    public static void addShapedRecipe(ItemStack output, Object ... inputs) {
        RecipeHandler.addShapedRecipe(null, output, inputs);
    }

    public static void addShapelessRecipe(MultiRecipe multi, ItemStack output, Object ... inputs) {
        String namespace = RecipeHandler.getNamespace();
        NonNullList ingredients = NonNullList.func_191196_a();
        for (Object input : inputs) {
            ingredients.add((Object)RecipeHandler.asIngredient(input));
        }
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Too many ingredients for shapeless recipe");
        }
        ShapelessRecipes recipe = new ShapelessRecipes(RecipeHandler.outputGroup(namespace, output), output, ingredients);
        if (multi != null) {
            multi.addRecipe((IRecipe)recipe);
        } else {
            RecipeHandler.addRecipe(RecipeHandler.unusedLocForOutput(namespace, output), (IRecipe)recipe);
        }
    }

    public static void addShapedRecipe(MultiRecipe multi, ItemStack output, Object ... inputs) {
        String namespace = RecipeHandler.getNamespace();
        ArrayList pattern = Lists.newArrayList();
        HashMap key = Maps.newHashMap();
        Iterator<Object> itr = Arrays.asList(inputs).iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 3) {
                    throw new IllegalArgumentException("Invalid string length for recipe " + str.length());
                }
                if (pattern.size() <= 2) {
                    pattern.add(str);
                    continue;
                }
                throw new IllegalArgumentException("Recipe has too many crafting rows!");
            }
            if (obj instanceof Character) {
                key.put(((Character)obj).toString(), RecipeHandler.asIngredient(itr.next()));
                continue;
            }
            throw new IllegalArgumentException("Unexpected argument of type " + obj.getClass().toString());
        }
        int width = ((String)pattern.get(0)).length();
        int height = pattern.size();
        try {
            key.put(" ", Ingredient.field_193370_a);
            NonNullList<Ingredient> ingredients = RecipeHandler.prepareMaterials(pattern.toArray(new String[pattern.size()]), key, width, height);
            ShapedRecipes recipe = new ShapedRecipes(RecipeHandler.outputGroup(namespace, output), width, height, ingredients, output);
            if (multi != null) {
                multi.addRecipe((IRecipe)recipe);
            } else {
                RecipeHandler.addRecipe(RecipeHandler.unusedLocForOutput(namespace, output), (IRecipe)recipe);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static NonNullList<Ingredient> prepareMaterials(String[] p_192402_0_, Map<String, Ingredient> p_192402_1_, int p_192402_2_, int p_192402_3_) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(p_192402_2_ * p_192402_3_), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(p_192402_1_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_192402_0_.length; ++i) {
            for (int j = 0; j < p_192402_0_[i].length(); ++j) {
                String s = p_192402_0_[i].substring(j, j + 1);
                Ingredient ingredient = p_192402_1_.get(s);
                set.remove(s);
                nonnulllist.set(j + p_192402_2_ * i, (Object)ingredient);
            }
        }
        return nonnulllist;
    }

    public static void addRecipe(ResourceLocation res, IRecipe recipe) {
        if (!(recipe instanceof ModRecipe) && recipe.func_77571_b().func_190926_b()) {
            throw new IllegalArgumentException("Illegal recipe output");
        }
        recipe.setRegistryName(res);
        usedNames.add(res);
        ProxyRegistry.register(recipe);
    }

    private static Ingredient asIngredient(Object object) {
        if (object instanceof Ingredient) {
            return (Ingredient)object;
        }
        if (object instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)object));
        }
        if (object instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)object)});
        }
        if (object instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)object});
        }
        if (object instanceof String) {
            return new OreIngredient((String)object);
        }
        throw new IllegalArgumentException("Cannot convert object of type " + object.getClass().toString() + " to an Ingredient!");
    }

    private static ResourceLocation unusedLocForOutput(String namespace, ItemStack output) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(namespace, output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (usedNames.contains(recipeLoc)) {
            recipeLoc = new ResourceLocation(namespace, baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    private static String outputGroup(String namespace, ItemStack output) {
        Block block;
        Item item = output.func_77973_b();
        if (item instanceof IRecipeGrouped) {
            return namespace + ":" + ((IRecipeGrouped)item).getRecipeGroup();
        }
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof IRecipeGrouped) {
            return namespace + ":" + ((IRecipeGrouped)block).getRecipeGroup();
        }
        return output.func_77973_b().getRegistryName().toString();
    }

    private static String getNamespace() {
        return Loader.instance().activeModContainer().getModId();
    }
}

