/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.block;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.arl.interf.IModBlock;
import vazkii.arl.item.ItemModBlockSlab;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;

public abstract class BlockModSlab
extends BlockSlab
implements IModBlock {
    static boolean tempDoubleSlab;
    boolean doubleSlab;
    private final String[] variants;
    private final String bareName;
    public static final PropertyEnum prop;
    public static HashMap<BlockModSlab, BlockModSlab> halfSlabs;
    public static HashMap<BlockModSlab, BlockModSlab> fullSlabs;

    public BlockModSlab(String name, Material materialIn, boolean doubleSlab) {
        super(BlockModSlab.hacky(materialIn, doubleSlab));
        this.doubleSlab = doubleSlab;
        if (doubleSlab) {
            name = name + "_double";
        }
        this.variants = new String[]{name};
        this.bareName = name;
        this.func_149663_c(name);
        if (!doubleSlab) {
            this.field_149783_u = true;
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)prop, (Comparable)((Object)DummyEnum.BLARG)));
        }
        this.func_149647_a(doubleSlab ? null : CreativeTabs.field_78030_b);
    }

    public static Material hacky(Material m, boolean doubleSlab) {
        tempDoubleSlab = doubleSlab;
        return m;
    }

    public BlockStateContainer func_180661_e() {
        return tempDoubleSlab ? new BlockStateContainer((Block)this, new IProperty[]{this.getVariantProp()}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.getVariantProp()});
    }

    public IBlockState func_176203_a(int meta) {
        if (this.doubleSlab) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)(meta == 8 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        if (this.doubleSlab) {
            return 0;
        }
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0;
    }

    public BlockSlab getFullBlock() {
        return fullSlabs.get(this);
    }

    public BlockSlab getSingleBlock() {
        return halfSlabs.get(this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this.getSingleBlock());
    }

    public Item func_180660_a(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)this.getSingleBlock());
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return super.quantityDropped(state, fortune, random);
    }

    public void register() {
        this.setRegistryName(this.getPrefix() + this.bareName);
        ProxyRegistry.register(this);
        if (!this.func_176552_j()) {
            ProxyRegistry.register(new ItemModBlockSlab((Block)this, new ResourceLocation(this.getPrefix() + this.bareName)));
        }
    }

    @Override
    public String getBareName() {
        return this.bareName;
    }

    @Override
    public String[] getVariants() {
        return this.variants;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return null;
    }

    @Override
    public EnumRarity getBlockRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    @Override
    public IProperty[] getIgnoredProperties() {
        IProperty[] iPropertyArray;
        if (this.doubleSlab) {
            IProperty[] iPropertyArray2 = new IProperty[2];
            iPropertyArray2[0] = prop;
            iPropertyArray = iPropertyArray2;
            iPropertyArray2[1] = field_176554_a;
        } else {
            IProperty[] iPropertyArray3 = new IProperty[1];
            iPropertyArray = iPropertyArray3;
            iPropertyArray3[0] = prop;
        }
        return iPropertyArray;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public boolean func_176552_j() {
        return this.doubleSlab;
    }

    public boolean func_149730_j(IBlockState state) {
        return this.func_176552_j();
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = this.func_176221_a(base_state, world, pos);
        return this.func_176552_j() || state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP && side == EnumFacing.UP || state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM && side == EnumFacing.DOWN;
    }

    public IProperty<?> getVariantProp() {
        return prop;
    }

    public IProperty<?> func_176551_l() {
        return prop;
    }

    public Class getVariantEnum() {
        return DummyEnum.class;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return DummyEnum.BLARG;
    }

    public static void initSlab(Block base, int meta, BlockModSlab half, BlockModSlab full) {
        fullSlabs.put(half, full);
        fullSlabs.put(full, full);
        halfSlabs.put(half, half);
        halfSlabs.put(full, half);
        half.register();
        full.register();
        RecipeHandler.addOreDictRecipe(ProxyRegistry.newStack((Block)half, 6), "BBB", Character.valueOf('B'), ProxyRegistry.newStack(base, 1, meta));
    }

    static {
        prop = PropertyEnum.func_177709_a((String)"prop", DummyEnum.class);
        halfSlabs = new HashMap();
        fullSlabs = new HashMap();
    }

    public static enum DummyEnum implements BlockMetaVariants.EnumBase
    {
        BLARG;

    }
}

