/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.block.ItemBlockCore;
import cofh.core.energy.FurnaceFuelHandler;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFProps;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockStorageResource
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static ItemStack blockCharcoal;
    public static ItemStack blockCoke;

    public BlockStorageResource() {
        super(Material.field_151576_e, MapColor.field_151646_E, "thermalfoundation");
        this.func_149663_c("storage");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.CHARCOAL)));
        this.setHarvestLevel("pickaxe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "tile.thermalfoundation.storage." + Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].func_176610_l() + ".name";
    }

    public EnumRarity getRarity(ItemStack stack) {
        return Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].getRarity();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return ((Type)((Object)state.func_177229_b(VARIANT))).getResistance();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name + "_resource", "type=" + Type.values()[i].func_176610_l()));
        }
    }

    public boolean preInit() {
        this.setRegistryName("storage_resource");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        blockCharcoal = new ItemStack((Block)this, 1, Type.CHARCOAL.getMetadata());
        blockCoke = new ItemStack((Block)this, 1, Type.COKE.getMetadata());
        ItemHelper.registerWithHandlers((String)"blockCharcoal", (ItemStack)blockCharcoal);
        ItemHelper.registerWithHandlers((String)"blockFuelCoke", (ItemStack)blockCoke);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        RecipeHelper.addStorageRecipe((ItemStack)blockCharcoal, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
        RecipeHelper.addStorageRecipe((ItemStack)blockCoke, (String)"fuelCoke");
        FurnaceFuelHandler.registerFuel((ItemStack)blockCharcoal, (int)16000);
        FurnaceFuelHandler.registerFuel((ItemStack)blockCoke, (int)(TFProps.fuelCokeFuel * 10));
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        CHARCOAL(0, "charcoal"),
        COKE(1, "coke");

        private final int metadata;
        private final String name;
        private final int light;
        private final float hardness;
        private final float resistance;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, float hardness, float resistance, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.hardness = hardness;
            this.resistance = resistance;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, int light, float hardness, float resistance) {
            this(metadata, name, light, hardness, resistance, EnumRarity.COMMON);
        }

        private Type(int metadata, String name, float hardness, float resistance) {
            this(metadata, name, 0, hardness, resistance, EnumRarity.COMMON);
        }

        private Type(int metadata, String name, int light) {
            this(metadata, name, light, 5.0f, 6.0f, EnumRarity.COMMON);
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0, 5.0f, 6.0f, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }
    }
}

