/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.util.concurrent.ConcurrentHashMap;
import mod.chiselsandbits.render.cache.FormatInfo;
import mod.chiselsandbits.render.chiseledblock.IFaceBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class ChiselsAndBitsBakedQuad
extends BakedQuad {
    public static final ConcurrentHashMap<VertexFormat, FormatInfo> formatData = new ConcurrentHashMap();
    public static final VertexFormat VERTEX_FORMAT = new VertexFormat();

    private static int[] packData(VertexFormat format, float[][][] unpackedData) {
        FormatInfo fi = formatData.get(format);
        if (fi == null) {
            fi = new FormatInfo(format);
            formatData.put(format, fi);
        }
        return fi.pack(unpackedData);
    }

    public void pipe(IVertexConsumer consumer) {
        int[] eMap = LightUtil.mapFormats((VertexFormat)consumer.getVertexFormat(), (VertexFormat)this.format);
        consumer.setQuadTint(this.func_178211_c());
        consumer.setQuadOrientation(this.func_178210_d());
        consumer.setApplyDiffuseLighting(true);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().func_177345_h(); ++e) {
                if (eMap[e] != this.format.func_177345_h()) {
                    consumer.put(e, this.getRawPart(v, eMap[e]));
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    private float[] getRawPart(int v, int i) {
        return formatData.get(this.format).unpack(this.field_178215_a, v, i);
    }

    public int[] func_178209_a() {
        int[] tmpData = new int[this.format.func_177338_f()];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < this.format.func_177345_h(); ++e) {
                LightUtil.pack((float[])this.getRawPart(v, e), (int[])tmpData, (VertexFormat)this.format, (int)v, (int)e);
            }
        }
        return tmpData;
    }

    public ChiselsAndBitsBakedQuad(float[][][] unpackedData, int tint, EnumFacing orientation, TextureAtlasSprite sprite, VertexFormat format) {
        super(ChiselsAndBitsBakedQuad.packData(format, unpackedData), tint, orientation, sprite, true, format);
    }

    static {
        for (VertexFormatElement element : DefaultVertexFormats.field_176599_b.func_177343_g()) {
            VERTEX_FORMAT.func_181721_a(element);
        }
        VERTEX_FORMAT.func_181721_a(DefaultVertexFormats.field_181716_p);
    }

    public static class Builder
    implements IVertexConsumer,
    IFaceBuilder {
        private float[][][] unpackedData;
        private int tint = -1;
        private EnumFacing orientation;
        private final boolean isColored = false;
        private int vertices = 0;
        private int elements = 0;
        private final VertexFormat format;

        public Builder(VertexFormat format) {
            this.format = format;
        }

        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.orientation = orientation;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.getVertexFormat().func_177345_h()) {
                ++this.vertices;
                this.elements = 0;
            }
        }

        @Override
        public void begin() {
            if (this.format != this.getVertexFormat()) {
                throw new RuntimeException("Bad format, can only be CNB.");
            }
            this.unpackedData = new float[4][this.getVertexFormat().func_177345_h()][4];
            this.tint = -1;
            this.orientation = null;
            this.vertices = 0;
            this.elements = 0;
        }

        @Override
        public BakedQuad create(TextureAtlasSprite sprite) {
            return new ChiselsAndBitsBakedQuad(this.unpackedData, this.tint, this.orientation, sprite, this.getFormat());
        }

        @Override
        public void setFace(EnumFacing myFace, int tintIndex) {
            this.setQuadOrientation(myFace);
            this.setQuadTint(tintIndex);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        public void setTexture(TextureAtlasSprite texture) {
        }

        @Override
        public VertexFormat getFormat() {
            return this.format;
        }
    }

    public static class Colored
    extends ChiselsAndBitsBakedQuad {
        public Colored(float[][][] unpackedData, int tint, EnumFacing orientation, TextureAtlasSprite sprite, VertexFormat format) {
            super(unpackedData, tint, orientation, sprite, format);
        }
    }
}

