/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import java.util.ArrayList;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselTypeIterator;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ContinousBits;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.helpers.VoxelRegionSrc;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PacketChisel
extends ModPacket {
    BitLocation from;
    BitLocation to;
    BitOperation place;
    EnumFacing side;
    ChiselMode mode;
    EnumHand hand;

    @Deprecated
    public PacketChisel() {
    }

    public PacketChisel(BitOperation place, BitLocation from, BitLocation to, EnumFacing side, ChiselMode mode, EnumHand hand) {
        this.place = place;
        this.from = BitLocation.min(from, to);
        this.to = BitLocation.max(from, to);
        this.side = side;
        this.mode = mode;
        this.hand = hand;
    }

    public PacketChisel(BitOperation place, BitLocation location, EnumFacing side, ChiselMode mode, EnumHand hand) {
        this.place = place;
        this.from = this.to = location;
        this.side = side;
        this.mode = mode;
        this.hand = hand;
    }

    @Override
    public void server(EntityPlayerMP playerEntity) {
        this.doAction((EntityPlayer)playerEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAction(EntityPlayer who) {
        World world = who.field_70170_p;
        ActingPlayer player = ActingPlayer.actingAs(who, this.hand);
        int minX = Math.min(this.from.blockPos.func_177958_n(), this.to.blockPos.func_177958_n());
        int maxX = Math.max(this.from.blockPos.func_177958_n(), this.to.blockPos.func_177958_n());
        int minY = Math.min(this.from.blockPos.func_177956_o(), this.to.blockPos.func_177956_o());
        int maxY = Math.max(this.from.blockPos.func_177956_o(), this.to.blockPos.func_177956_o());
        int minZ = Math.min(this.from.blockPos.func_177952_p(), this.to.blockPos.func_177952_p());
        int maxZ = Math.max(this.from.blockPos.func_177952_p(), this.to.blockPos.func_177952_p());
        int returnVal = 0;
        boolean update = false;
        ItemStack extracted = null;
        ItemStack bitPlaced = null;
        ArrayList<EntityItem> spawnlist = new ArrayList<EntityItem>();
        UndoTracker.getInstance().beginGroup(who);
        try {
            for (int xOff = minX; xOff <= maxX; ++xOff) {
                for (int yOff = minY; yOff <= maxY; ++yOff) {
                    for (int zOff = minZ; zOff <= maxZ; ++zOff) {
                        TileEntityBlockChiseled te;
                        BlockPos pos = new BlockPos(xOff, yOff, zOff);
                        int placeStateID = this.place.usesBits() ? ItemChiseledBit.getStackState(who.func_184586_b(this.hand)) : 0;
                        ContinousChisels chisels = new ContinousChisels(player, pos, this.side);
                        ContinousBits bits = new ContinousBits(player, pos, placeStateID);
                        IBlockState blkstate = world.func_180495_p(pos);
                        Block blkObj = blkstate.func_177230_c();
                        if (this.place.usesChisels() && (!chisels.isValid() || blkObj == null || blkstate == null || !ItemChisel.canMine(chisels, blkstate, who, world, pos)) || this.place.usesBits() && (!bits.isValid() || blkObj == null || blkstate == null)) continue;
                        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && this.place.usesBits()) {
                            world.func_175698_g(pos);
                        }
                        if (BlockChiseled.replaceWithChisled(world, pos, blkstate, placeStateID, true)) {
                            blkstate = world.func_180495_p(pos);
                            blkObj = blkstate.func_177230_c();
                        }
                        if (!((te = ModUtil.getChiseledTileEntity(world, pos, this.place.usesBits())) instanceof TileEntityBlockChiseled)) continue;
                        TileEntityBlockChiseled tec = te;
                        VoxelBlob mask = new VoxelBlob();
                        MCMultipartProxy.proxyMCMultiPart.addFiller(world, pos, mask);
                        VoxelBlob vb = tec.getBlob();
                        ChiselIterator i = this.getIterator(new VoxelRegionSrc(world, pos, 1), pos, this.place);
                        while (i.hasNext()) {
                            if (this.place.usesChisels() && chisels.isValid() && (!this.place.usesBits() || vb.get(i.x(), i.y(), i.z()) != placeStateID)) {
                                extracted = ItemChisel.chiselBlock(chisels, player, vb, world, pos, i.side(), i.x(), i.y(), i.z(), extracted, spawnlist);
                            }
                            if (!this.place.usesBits() || !bits.isValid() || mask.get(i.x(), i.y(), i.z()) != 0) continue;
                            bitPlaced = bits.getItem(0).getStack();
                            update = ItemChiseledBit.placeBit(bits, player, vb, i.x(), i.y(), i.z()) || update;
                        }
                        if (update) {
                            tec.completeEditOperation(vb);
                            ++returnVal;
                            continue;
                        }
                        if (extracted == null) continue;
                        tec.completeEditOperation(vb);
                        ++returnVal;
                    }
                }
            }
            BitInventoryFeeder feeder = new BitInventoryFeeder(who, world);
            for (EntityItem ei : spawnlist) {
                feeder.addItem(ei);
                ItemBitBag.cleanupInventory(who, ei.func_92059_d());
            }
            if (this.place.usesBits()) {
                ItemBitBag.cleanupInventory(who, bitPlaced != null ? bitPlaced : new ItemStack((Item)ChiselsAndBits.getItems().itemBlockBit, 1, Short.MAX_VALUE));
            }
        }
        finally {
            UndoTracker.getInstance().endGroup(who);
        }
        return returnVal;
    }

    private ChiselIterator getIterator(VoxelRegionSrc vb, BlockPos pos, BitOperation place) {
        if (this.mode == ChiselMode.DRAWN_REGION) {
            int bitX = pos.func_177958_n() == this.from.blockPos.func_177958_n() ? this.from.bitX : 0;
            int bitY = pos.func_177956_o() == this.from.blockPos.func_177956_o() ? this.from.bitY : 0;
            int bitZ = pos.func_177952_p() == this.from.blockPos.func_177952_p() ? this.from.bitZ : 0;
            int scaleX = (pos.func_177958_n() == this.to.blockPos.func_177958_n() ? this.to.bitX : 15) - bitX + 1;
            int scaleY = (pos.func_177956_o() == this.to.blockPos.func_177956_o() ? this.to.bitY : 15) - bitY + 1;
            int scaleZ = (pos.func_177952_p() == this.to.blockPos.func_177952_p() ? this.to.bitZ : 15) - bitZ + 1;
            return new ChiselTypeIterator(16, bitX, bitY, bitZ, scaleX, scaleY, scaleZ, this.side);
        }
        return ChiselTypeIterator.create(16, this.from.bitX, this.from.bitY, this.from.bitZ, vb, this.mode, this.side, place.usePlacementOffset());
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.from = this.readBitLoc(buffer);
        this.to = this.readBitLoc(buffer);
        this.place = (BitOperation)buffer.func_179257_a(BitOperation.class);
        this.side = EnumFacing.field_82609_l[buffer.func_150792_a()];
        this.mode = ChiselMode.values()[buffer.func_150792_a()];
        this.hand = EnumHand.values()[buffer.func_150792_a()];
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        this.writeBitLoc(this.from, buffer);
        this.writeBitLoc(this.to, buffer);
        buffer.func_179249_a((Enum)this.place);
        buffer.func_150787_b(this.side.ordinal());
        buffer.func_150787_b(this.mode.ordinal());
        buffer.func_150787_b(this.hand.ordinal());
    }

    private BitLocation readBitLoc(PacketBuffer buffer) {
        return new BitLocation(buffer.func_179259_c(), buffer.readByte(), buffer.readByte(), buffer.readByte());
    }

    private void writeBitLoc(BitLocation from2, PacketBuffer buffer) {
        buffer.func_179255_a(from2.blockPos);
        buffer.writeByte(from2.bitX);
        buffer.writeByte(from2.bitY);
        buffer.writeByte(from2.bitZ);
    }
}

