/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.compat.CompatManager;
import erogenousbeef.bigreactors.common.multiblock.computer.ReactorComputer;
import erogenousbeef.bigreactors.common.multiblock.computer.ReactorComputerCC;
import erogenousbeef.bigreactors.common.multiblock.computer.ReactorComputerOC;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart", modid="opencomputers")})
public class TileEntityReactorComputerPort
extends TileEntityReactorPart {
    private final ReactorComputer _ccComputer = CompatManager.isModLoaded("computercraft") ? ReactorComputerCC.create(this) : null;
    private final ReactorComputer _ocComputer = CompatManager.isModLoaded("opencomputers") ? ReactorComputerOC.create(this) : null;

    @Optional.Method(modid="opencomputers")
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return null != this._ocComputer && ReactorComputerOC.isComputerCapability(capability) || super.hasCapability(capability, facing);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (null != this._ocComputer && ReactorComputerOC.isComputerCapability(capability)) {
            return (T)this._ocComputer;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="computercraft")
    public ReactorComputer getComputerCraftPeripheral() {
        return this._ccComputer;
    }

    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        if (null != this._ccComputer) {
            this._ccComputer.onAttachedToController();
        }
        if (null != this._ocComputer) {
            this._ocComputer.onAttachedToController();
        }
    }

    public void onDetached(MultiblockControllerBase oldController) {
        super.onDetached(oldController);
        if (null != this._ccComputer) {
            this._ccComputer.onDetachedFromController();
        }
        if (null != this._ocComputer) {
            this._ocComputer.onDetachedFromController();
        }
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (null != this._ccComputer) {
            this._ccComputer.syncDataFrom(data, syncReason);
        }
        if (null != this._ocComputer) {
            this._ocComputer.syncDataFrom(data, syncReason);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (null != this._ccComputer) {
            this._ccComputer.syncDataTo(data, syncReason);
        }
        if (null != this._ocComputer) {
            this._ocComputer.syncDataTo(data, syncReason);
        }
    }
}

