/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.lib.MetalSize;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.crafting.RecipeHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockBRMetal
extends ModBlock {
    private List<ItemStack> _subBlocks;

    public BlockBRMetal(String blockName) {
        super(blockName, Material.field_151573_f);
        this.func_149647_a(BigReactors.TAB);
        this.func_149711_c(2.0f);
        this._subBlocks = null;
    }

    public void onRegisterItemBlocks(@Nonnull IForgeRegistry<Item> registry) {
        registry.register(new ItemBlockMetal((Block)this).setRegistryName(this.getRegistryName()));
    }

    @SideOnly(value=Side.CLIENT)
    public void onRegisterModels() {
        ResourceLocation location = this.getRegistryName();
        Item item = Item.func_150898_a((Block)this);
        for (MetalType metal : MetalType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metal.toMeta(), (ModelResourceLocation)new ModelResourceLocation(location, String.format("metal=%s", metal.func_176610_l())));
        }
    }

    public void onRegisterOreDictionaryEntries() {
        MetalType[] metals = MetalType.values();
        int length = metals.length;
        for (int i = 0; i < length; ++i) {
            OreDictionary.registerOre((String)metals[i].getOreDictionaryName(MetalSize.Block), (ItemStack)this.createItemStack(metals[i], 1));
        }
    }

    public void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
        ResourceLocation group = BigReactors.createResourceLocation("metals");
        for (MetalType metal : MetalType.VALUES) {
            ItemStack block = this.createItemStack(metal, 1);
            ItemStack ingot = BrItems.ingotMetals.createItemStack(metal, 1);
            RecipeHelper.addShapelessRecipe((ResourceLocation)BigReactors.createResourceLocation(metal.func_176610_l() + MetalSize.Block.name()), (ResourceLocation)group, (ItemStack)block, (Object[])new Object[]{ingot, ingot, ingot, ingot, ingot, ingot, ingot, ingot, ingot});
            ingot = ItemHelper.stackFrom((ItemStack)ingot, (int)9);
            RecipeHelper.addShapelessRecipe((ResourceLocation)BigReactors.createResourceLocation(metal.func_176610_l() + MetalSize.Ingot.name()), (ResourceLocation)group, (ItemStack)ingot, (Object[])new Object[]{block});
        }
        ItemStack ludicriteBlock = this.createItemStack(MetalType.Ludicrite, 1);
        RecipeHelper.addShapedOreDictRecipe((ItemStack)ludicriteBlock, (Object[])new Object[]{"BPB", "ENE", "BPB", Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('E'), Blocks.field_150475_bE, Character.valueOf('B'), BigReactors.CONFIG.recipeBlutoniumIngotName});
        if (OreDictionaryHelper.doesOreNameExist((String)"blockEnderium")) {
            RecipeHelper.addShapedOreDictRecipe((ItemStack)ludicriteBlock, (Object[])new Object[]{"BRB", "E E", "BRB", Character.valueOf('B'), BigReactors.CONFIG.recipeBlutoniumIngotName, Character.valueOf('R'), Items.field_151072_bj, Character.valueOf('E'), "blockEnderium"});
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (null == this._subBlocks) {
            MetalType[] types = MetalType.VALUES;
            int length = types.length;
            this._subBlocks = new ArrayList<ItemStack>(length);
            for (int i = 0; i < length; ++i) {
                this._subBlocks.add(new ItemStack((Block)this, 1, types[i].toMeta()));
            }
        }
        list.addAll(this._subBlocks);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(Properties.METAL, (Comparable)((Object)MetalType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((MetalType)((Object)state.func_177229_b(Properties.METAL))).toMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack createItemStack(MetalType type, int amount) {
        return new ItemStack((Block)this, amount, type.toMeta());
    }

    public static boolean isMetal(IBlockState state, MetalType metal) {
        return BrBlocks.blockMetals == state.func_177230_c() && state.func_177229_b(Properties.METAL) == metal;
    }

    protected void buildBlockState(BlockStateContainer.Builder builder) {
        builder.add(new IProperty[]{Properties.METAL});
    }

    private static class ItemBlockMetal
    extends ItemBlock {
        public ItemBlockMetal(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        public String func_77667_c(ItemStack stack) {
            return super.func_77658_a() + "." + MetalType.fromMeta(stack.func_77960_j()).func_176610_l();
        }

        public int func_77647_b(int meta) {
            return meta;
        }
    }
}

