/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.render;

import java.text.DecimalFormat;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.IVehicleType;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.registry.VehicleRegistry;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderAircraft;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderBallistaMobile;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderBallistaStand;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderBatteringRam;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderBoatBallista;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderBoatCatapult;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderBoatTransport;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCannonMobileFixed;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCannonStandFixed;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCannonStandTurret;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCatapultMobileFixed;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCatapultMobileTurret;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCatapultStandFixed;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderCatapultStandTurret;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderChestCart;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderHelicopter;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderHwacha;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderSubmarine;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderTrebuchetLarge;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderTrebuchetMobileFixed;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderTrebuchetStandFixed;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderTrebuchetStandTurret;
import net.shadowmage.ancientwarfare.vehicle.render.vehicle.RenderVehicleBase;

public class RenderVehicle
extends Render<VehicleBase> {
    private HashMap<IVehicleType, RenderVehicleBase> vehicleRenders = new HashMap();
    private DecimalFormat formatter1d = new DecimalFormat("#.#");

    public RenderVehicle(RenderManager renderManager) {
        super(renderManager);
        this.vehicleRenders.put(VehicleRegistry.CATAPULT_STAND_FIXED, new RenderCatapultStandFixed(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CATAPULT_STAND_TURRET, new RenderCatapultStandTurret(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CATAPULT_MOBILE_FIXED, new RenderCatapultMobileFixed(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CATAPULT_MOBILE_TURRET, new RenderCatapultMobileTurret(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BALLISTA_STAND_FIXED, new RenderBallistaStand(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BALLISTA_STAND_TURRET, new RenderBallistaStand(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BALLISTA_MOBILE_FIXED, new RenderBallistaMobile(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BALLISTA_MOBILE_TURRET, new RenderBallistaMobile(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BATTERING_RAM, new RenderBatteringRam(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CANNON_STAND_FIXED, new RenderCannonStandFixed(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CANNON_STAND_TURRET, new RenderCannonStandTurret(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CANNON_MOBILE_FIXED, new RenderCannonMobileFixed(renderManager));
        this.vehicleRenders.put(VehicleRegistry.HWACHA, new RenderHwacha(renderManager));
        this.vehicleRenders.put(VehicleRegistry.TREBUCHET_STAND_FIXED, new RenderTrebuchetStandFixed(renderManager));
        this.vehicleRenders.put(VehicleRegistry.TREBUCHET_STAND_TURRET, new RenderTrebuchetStandTurret(renderManager));
        this.vehicleRenders.put(VehicleRegistry.TREBUCHET_MOBILE_FIXED, new RenderTrebuchetMobileFixed(renderManager));
        this.vehicleRenders.put(VehicleRegistry.TREBUCHET_LARGE, new RenderTrebuchetLarge(renderManager));
        this.vehicleRenders.put(VehicleRegistry.CHEST_CART, new RenderChestCart(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BOAT_BALLISTA, new RenderBoatBallista(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BOAT_CATAPULT, new RenderBoatCatapult(renderManager));
        this.vehicleRenders.put(VehicleRegistry.BOAT_TRANSPORT, new RenderBoatTransport(renderManager));
        this.vehicleRenders.put(VehicleRegistry.AIR_BOMBER, new RenderAircraft(renderManager));
        this.vehicleRenders.put(VehicleRegistry.AIR_FIGHTER, new RenderAircraft(renderManager));
        this.vehicleRenders.put(VehicleRegistry.AIR_HELICOPTER, new RenderHelicopter(renderManager));
        this.vehicleRenders.put(VehicleRegistry.SUBMARINE_TEST, new RenderSubmarine(renderManager));
    }

    public void doRender(VehicleBase vehicle, double x, double y, double z, float renderYaw, float partialTicks) {
        boolean useAlpha = false;
        if (!AWVehicleStatics.renderVehiclesInFirstPerson && vehicle.func_184179_bs() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            useAlpha = true;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)renderYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (vehicle.hitAnimationTicks > 0) {
            float percent = (float)vehicle.hitAnimationTicks / 20.0f;
            GlStateManager.func_179131_c((float)1.0f, (float)(1.0f - percent), (float)(1.0f - percent), (float)1.0f);
        }
        this.func_110776_a(vehicle.getTexture());
        RenderVehicleBase render = this.vehicleRenders.get(vehicle.vehicleType);
        render.renderVehicle(vehicle, x, y, z, renderYaw, partialTicks);
        render.renderVehicleFlag();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        if (useAlpha) {
            GlStateManager.func_179084_k();
        }
        if (this.isInWorld(vehicle) && AWVehicleStatics.renderVehicleNameplates && vehicle.func_184179_bs() != Minecraft.func_71410_x().field_71439_g) {
            this.renderNamePlate(vehicle, x, y, z, renderYaw, partialTicks);
        }
    }

    private boolean isInWorld(VehicleBase vehicle) {
        return vehicle.field_70163_u > 0.0;
    }

    private void renderNamePlate(VehicleBase vehicle, double x, double y, double z, float yaw, float tick) {
        double var10 = vehicle.func_70068_e(this.field_76990_c.field_78734_h);
        int par9 = 64;
        String par2Str = vehicle.vehicleType.getLocalizedName() + " " + this.formatter1d.format(vehicle.getHealth()) + "/" + this.formatter1d.format(vehicle.baseHealth);
        if (var10 <= (double)(par9 * par9)) {
            FontRenderer var12 = this.func_76983_a();
            float var13 = 1.6f;
            float var14 = 0.016666668f * var13;
            float namePlateHeight = vehicle.field_70131_O + 0.75f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.0f), (float)((float)y + namePlateHeight), (float)((float)z));
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tesselator.func_178180_c();
            int var16 = 0;
            GlStateManager.func_179090_x();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            int var17 = var12.func_78256_a(par2Str) / 2;
            bufferBuilder.func_181662_b((double)(-var17 - 1), (double)(-1 + var16), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            bufferBuilder.func_181662_b((double)(-var17 - 1), (double)(8 + var16), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            bufferBuilder.func_181662_b((double)(var17 + 1), (double)(8 + var16), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            bufferBuilder.func_181662_b((double)(var17 + 1), (double)(-1 + var16), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tesselator.func_78381_a();
            GlStateManager.func_179098_w();
            var12.func_78276_b(par2Str, -var12.func_78256_a(par2Str) / 2, var16, 0x20FFFFFF);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            var12.func_78276_b(par2Str, -var12.func_78256_a(par2Str) / 2, var16, -1);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(VehicleBase entity) {
        return entity.getTexture();
    }
}

