/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.vehicle.armors.IVehicleArmor;
import net.shadowmage.ancientwarfare.vehicle.armors.VehicleArmorIron;
import net.shadowmage.ancientwarfare.vehicle.armors.VehicleArmorObsidian;
import net.shadowmage.ancientwarfare.vehicle.armors.VehicleArmorStone;
import net.shadowmage.ancientwarfare.vehicle.item.ItemArmor;

public class ArmorRegistry {
    public static IVehicleArmor armorStone;
    public static IVehicleArmor armorIron;
    public static IVehicleArmor armorObsidian;
    private static Map<ResourceLocation, IVehicleArmor> armorInstances;

    private ArmorRegistry() {
    }

    public static void registerArmorTypes(IForgeRegistry<Item> registry) {
        armorStone = ArmorRegistry.registerArmorType(new VehicleArmorStone(), registry);
        armorIron = ArmorRegistry.registerArmorType(new VehicleArmorIron(), registry);
        armorObsidian = ArmorRegistry.registerArmorType(new VehicleArmorObsidian(), registry);
    }

    private static IVehicleArmor registerArmorType(IVehicleArmor armor, IForgeRegistry<Item> registry) {
        armorInstances.put(armor.getRegistryName(), armor);
        ItemArmor item = new ItemArmor(armor.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
        return armor;
    }

    public static Optional<IVehicleArmor> getArmorType(ResourceLocation registryName) {
        return Optional.ofNullable(armorInstances.get(registryName));
    }

    public static Optional<IVehicleArmor> getArmorForStack(ItemStack stack) {
        return Optional.ofNullable(armorInstances.get(stack.func_77973_b().getRegistryName()));
    }

    static {
        armorInstances = new HashMap<ResourceLocation, IVehicleArmor>();
    }
}

