/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccess;

public class PathUtils {
    private static int[][] offsets = new int[8][2];

    public static Node getClosestPathableTo(PathWorldAccess world, int x, int y, int z, int maxH, int maxV, int ox, int oy, int oz) {
        Node closest = new Node(x, y, z);
        float closeDist = Float.POSITIVE_INFINITY;
        float tcloseDist = Float.POSITIVE_INFINITY;
        for (int y1 = y - maxV; y1 <= y + maxV; ++y1) {
            for (int x1 = x - maxH; x1 <= x + maxH; ++x1) {
                for (int z1 = z - maxH; z1 <= z + maxH; ++z1) {
                    if (!world.isWalkable(x1, y1, z1)) continue;
                    float dist = Trig.getDistance(x, y, z, x1, y1, z1);
                    float tdist = Trig.getDistance(ox, oy, oz, x1, y1, z1);
                    if (!(dist < closeDist) || !(tdist < tcloseDist)) continue;
                    closeDist = dist;
                    tcloseDist = tdist;
                    closest.reassign(x1, y1, z1);
                }
            }
        }
        return closest;
    }

    public static List<Node> guidedCrawl(PathWorldAccess world, int ex, int ey, int ez, int tx, int ty, int tz, int numOfNodes, Random rng) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int cx = ex;
        int cy = ey;
        int cz = ez;
        int mx = tx - ex;
        int mz = tz - ez;
        int n = mx < 0 ? -1 : (mx = mx > 1 ? 1 : mx);
        mz = mz < 0 ? -1 : (mz > 1 ? 1 : mz);
        int moveDir = 8;
        int my = 0;
        int dx = mx;
        int dz = mz;
        int dy = my;
        nodes.add(new Node(cx, cy, cz));
        for (int i = 0; i < numOfNodes; ++i) {
            if (tx < cy && world.isWalkable(cx, cy - 1, cz)) {
                nodes.add(new Node(cx, --cy, cz));
            } else if (tx > cy && world.isWalkable(cx, cy + 1, cz)) {
                nodes.add(new Node(cx, ++cy, cz));
            } else if (world.isWalkable(cx + mx, cy + dy, cz + mz)) {
                dx = mx;
                dz = mz;
                nodes.add(new Node(cx += dx, cy += dy, cz += dz));
            } else if (world.isWalkable(cx + dx, cy + dy, cz + dz)) {
                nodes.add(new Node(cx += dx, cy += dy, cz += dz));
            } else if (world.isWalkable(cx + dx, cy, cz + dz)) {
                dy = 0;
                nodes.add(new Node(cx += dx, cy += dy, cz += dz));
            } else if (world.isWalkable(cx + dx, cy - 1, cz + dz)) {
                dy = -1;
                nodes.add(new Node(cx += dx, cy += dy, cz += dz));
            } else if (world.isWalkable(cx + dx, cy + 1, cz + dz)) {
                dy = 1;
                nodes.add(new Node(cx += dx, cy += dy, cz += dz));
            } else {
                int turn = PathUtils.getRotationTowardTarget(dx, dz, mx, mz);
                int[] offset = turn <= 0 ? PathUtils.getRotatedMoveDelta(dx, dz, -1) : PathUtils.getRotatedMoveDelta(dx, dz, 1);
                if (world.isWalkable(cx + offset[0], cy, cz + offset[1])) {
                    dx = offset[0];
                    dz = offset[1];
                    dy = 0;
                    nodes.add(new Node(cx += dx, cy += dy, cz += dz));
                } else if (world.isWalkable(cx + offset[0], cy - 1, cz + offset[1])) {
                    dx = offset[0];
                    dz = offset[1];
                    dy = -1;
                    nodes.add(new Node(cx += dx, cy += dy, cz += dz));
                } else if (world.isWalkable(cx + offset[0], cy + 1, cz + offset[1])) {
                    dx = offset[0];
                    dz = offset[1];
                    dy = 1;
                    nodes.add(new Node(cx += dx, cy += dy, cz += dz));
                }
            }
            mx = tx - cx;
            mz = tz - cz;
            int n2 = mx < 0 ? -1 : (mx = mx > 1 ? 1 : mx);
            int n3 = mz < 0 ? -1 : (mz = mz > 1 ? 1 : mz);
            if (cx == tx && cy == ty && cz == tz) break;
        }
        return nodes;
    }

    private static int getRotationAmount(int amt, int base) {
        while (amt < 0) {
            amt += 8;
        }
        return amt;
    }

    private static int getRotationTowardTarget(int dx, int dz, int mx, int mz) {
        boolean foundCurrent = false;
        boolean foundBase = false;
        int currentOffset = 0;
        int baseOffset = 0;
        for (int i = 0; i < offsets.length; ++i) {
            int[] offset = offsets[i];
            if (offset[0] == dx && offset[1] == dz) {
                currentOffset = i;
                foundCurrent = true;
            }
            if (offset[0] == mx && offset[1] == mz) {
                baseOffset = i;
                foundBase = true;
            }
            if (foundBase && foundCurrent) break;
        }
        return currentOffset - baseOffset;
    }

    private static int[] getRotatedMoveDelta(int dx, int dz, int turnAmt) {
        int i;
        while (turnAmt < 0) {
            turnAmt += 8;
        }
        int rightTurns = turnAmt;
        int offsetNum = 0;
        for (i = 0; i < offsets.length; ++i) {
            int[] offset = offsets[i];
            if (offset[0] != dx || offset[1] != dz) continue;
            offsetNum = i;
            break;
        }
        for (i = 0; i < rightTurns; ++i) {
            if (++offsetNum < offsets.length) continue;
            offsetNum = 0;
        }
        if (offsetNum < 0) {
            offsetNum = 0;
        } else if (offsetNum >= offsets.length) {
            offsetNum = 0;
        }
        return offsets[offsetNum];
    }

    public static boolean canPathStraightToTargetLevel(PathWorldAccess worldAccess, int x0, int ey, int z0, int x1, int ty, int z1) {
        if (ey != ty) {
            return false;
        }
        int dx = Math.abs(x1 - x0);
        int dz = Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int err = dx - dz;
        boolean swim = worldAccess.canSwim;
        worldAccess.canSwim = false;
        boolean canPath = true;
        for (int i = 0; i < dx + dz; ++i) {
            BlockPos pos = new BlockPos(x0, ey, z0);
            if (worldAccess.isDoor(pos)) {
                canPath = false;
                break;
            }
            if (worldAccess.isLadder(pos)) {
                canPath = false;
                break;
            }
            if (!worldAccess.isWalkable(x0, ey, z0)) {
                canPath = false;
                break;
            }
            if (x0 == x1 && z0 == z1) break;
            int e2 = 2 * err;
            if (e2 > -dz) {
                err -= dz;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            z0 += sz;
        }
        worldAccess.canSwim = swim;
        return canPath;
    }

    public static boolean canPathStraightToTarget(PathWorldAccess worldAccess, int ex, int ey, int ez, BlockPos target) {
        int yOffset = target.func_177956_o() - ey;
        int currentY = ey;
        if (Math.abs(yOffset) > 1) {
            return false;
        }
        int dx = Math.abs(target.func_177958_n() - ex);
        int dz = Math.abs(target.func_177952_p() - ez);
        int px = ex;
        int pz = ez;
        int sx = ex < target.func_177958_n() ? 1 : -1;
        int sz = ez < target.func_177952_p() ? 1 : -1;
        int err = dx - dz;
        int cy = ey;
        boolean swim = worldAccess.canSwim;
        worldAccess.canSwim = false;
        boolean canPath = true;
        for (int i = 0; i < dx + dz; ++i) {
            if (worldAccess.isDoor(new BlockPos(ex, cy, ez))) {
                canPath = false;
                break;
            }
            if (worldAccess.isLadder(new BlockPos(ex, cy, ey))) {
                canPath = false;
                break;
            }
            if (worldAccess.isWalkable(ex, cy - 1, ez) && !worldAccess.checkBlockBounds(ex, cy + 1, ez)) {
                --cy;
            } else if (!worldAccess.isWalkable(ex, cy, ez)) {
                if (worldAccess.isWalkable(ex, cy + 1, ez) && !worldAccess.checkBlockBounds(px, cy + 2, pz)) {
                    ++cy;
                } else {
                    canPath = false;
                    break;
                }
            }
            if (Math.abs(cy - target.func_177956_o()) > 1) {
                canPath = false;
                break;
            }
            if (ex == target.func_177958_n() && ez == target.func_177952_p()) break;
            int e2 = 2 * err;
            px = ex;
            pz = ez;
            if (e2 > -dz) {
                err -= dz;
                ex += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            ez += sz;
        }
        worldAccess.canSwim = swim;
        return canPath;
    }

    public static List<BlockPos> getPositionsBetween2(float x0, float z0, float x1, float z1) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        float dx = (int)Math.abs(x1 - x0);
        float dz = (int)Math.abs(z1 - z0);
        float sx = x0 < x1 ? 1.0f : -1.0f;
        float sz = z0 < z1 ? 1.0f : -1.0f;
        float err = dx - dz;
        int i = 0;
        while ((float)i < dx + dz) {
            blocks.add(new BlockPos((double)x0, 0.0, (double)z0));
            if (x0 == x1 && z0 == z1) break;
            float e2 = 2.0f * err;
            if (e2 > -dz) {
                err -= dz;
                x0 += sx;
            }
            if (e2 < dx) {
                err += dx;
                z0 += sz;
            }
            ++i;
        }
        return blocks;
    }

    public static List<BlockPos> getPositionsBetween(float x0, float y0, float z0, float x1, float y1, float z1) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        int dx = (int)Math.abs(x1 - x0);
        int dz = (int)Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int e = 0;
        for (int i = 0; i < dx + dz; ++i) {
            blocks.add(new BlockPos((double)x0, (double)y0, (double)z0));
            int e1 = e + dz;
            int e2 = e - dx;
            if (Math.abs(e1) < Math.abs(e2)) {
                x0 += (float)sx;
                e = e1;
                continue;
            }
            z0 += (float)sz;
            e = e2;
        }
        blocks.add(new BlockPos((double)x0, (double)y0, (double)z0));
        return blocks;
    }

    static {
        PathUtils.offsets[0] = new int[]{0, 1};
        PathUtils.offsets[1] = new int[]{-1, 1};
        PathUtils.offsets[2] = new int[]{-1, 0};
        PathUtils.offsets[3] = new int[]{-1, -1};
        PathUtils.offsets[4] = new int[]{0, -1};
        PathUtils.offsets[5] = new int[]{1, -1};
        PathUtils.offsets[6] = new int[]{1, 0};
        PathUtils.offsets[7] = new int[]{1, 1};
    }
}

