/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.PriorityQueue;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.vehicle.pathing.IPathableCallback;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathUtils;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccess;

public class PathFinderThetaStar {
    private PriorityQueue<Node> qNodes = new PriorityQueue();
    private ArrayList<Node> allNodes = new ArrayList();
    private ArrayList<Node> searchNodes = new ArrayList();
    private Node currentNode;
    int sx;
    int sy;
    int sz;
    int tx;
    int ty;
    int tz;
    int minx;
    int miny;
    int minz;
    int maxx;
    int maxy;
    int maxz;
    int searchBufferRange = 40;
    int maxRange = 80;
    PathWorldAccess world;
    long startTime;
    long runTime;
    public long maxRunTime = 20000000L;
    public long maxSearchIterations = 1200L;
    private Node bestEndNode = null;
    private float bestPathLength = 0.0f;
    private float bestPathDist = Float.POSITIVE_INFINITY;
    private int searchIteration;
    IPathableCallback caller = null;
    public boolean isSearching = false;
    protected boolean instantSearch = false;

    public void findPath(PathWorldAccess world, int x, int y, int z, BlockPos target, int maxRange, IPathableCallback caller, boolean instant) {
        this.allNodes.clear();
        this.qNodes.clear();
        this.searchNodes.clear();
        this.world = world;
        this.caller = caller;
        this.instantSearch = instant;
        this.isSearching = true;
        this.sx = x;
        this.sy = y;
        this.sz = z;
        this.tx = target.func_177958_n();
        this.ty = target.func_177956_o();
        this.tz = target.func_177952_p();
        this.maxRange = maxRange;
        this.minx = x < this.tx ? x : this.tx;
        this.maxx = x < this.tx ? this.tx : x;
        this.miny = y < this.ty ? y : this.ty;
        this.maxy = y < this.ty ? this.ty : y;
        this.minz = z < this.tz ? z : this.tz;
        this.maxz = z < this.tz ? this.tz : z;
        this.minx -= this.searchBufferRange;
        this.maxx += this.searchBufferRange;
        this.miny -= this.searchBufferRange;
        this.maxy += this.searchBufferRange;
        this.minz -= this.searchBufferRange;
        this.maxz += this.searchBufferRange;
        this.startTime = System.nanoTime();
        this.currentNode = this.getOrMakeNode(this.sx, this.sy, this.sz, null);
        this.currentNode.g = 0.0f;
        this.currentNode.f = this.currentNode.getH(this.tx, this.ty, this.tz);
        this.qNodes.offer(this.currentNode);
        this.bestEndNode = this.currentNode;
        this.bestPathLength = 0.0f;
        this.bestPathDist = Float.POSITIVE_INFINITY;
        this.searchIteration = 0;
        this.runTime = 0L;
    }

    protected void onPathFound() {
        LinkedList<Node> path = new LinkedList<Node>();
        Node n = this.currentNode;
        Node c = null;
        Node p = null;
        while (n != null) {
            p = c;
            c = new Node(n.x, n.y, n.z);
            c.parentNode = p;
            path.push(c);
            n = n.parentNode;
        }
        if (this.caller != null) {
            this.caller.onPathFound(path);
        }
        this.currentNode = null;
        this.world = null;
        this.bestEndNode = null;
        this.allNodes.clear();
        this.qNodes.clear();
        this.searchNodes.clear();
        this.isSearching = false;
    }

    public void doSearchIterations(int num) {
        this.startTime = System.nanoTime();
        if (!this.isSearching) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            if (!this.searchLoop()) continue;
            this.onPathFound();
            this.isSearching = false;
            break;
        }
        this.runTime += System.nanoTime() - this.startTime;
    }

    private boolean searchLoop() {
        boolean isDoor = false;
        boolean isPDoor = false;
        Node goalCache = new Node(this.tx, this.ty, this.tz);
        boolean goalWalkable = this.world.isWalkable(this.tx, this.ty, this.tz) && this.world.isWalkable(this.tx, this.ty + 1, this.tz);
        ++this.searchIteration;
        if (this.qNodes.isEmpty()) {
            return true;
        }
        this.currentNode = this.qNodes.poll();
        this.allNodes.add(this.currentNode);
        if (this.currentNode.equals(this.tx, this.ty, this.tz)) {
            return true;
        }
        if (!goalWalkable && (double)this.currentNode.getDistanceFrom(this.tx, this.ty, this.tz) <= 2.0) {
            return true;
        }
        if (this.shouldTerminateEarly()) {
            return true;
        }
        this.currentNode.closed = true;
        this.findNeighbors(this.currentNode);
        isDoor = this.world.isDoor(this.currentNode.getPos());
        isPDoor = this.currentNode.parentNode != null && this.world.isDoor(this.currentNode.parentNode.getPos());
        boolean isNDoor = false;
        for (Node n : this.searchNodes) {
            isNDoor = this.world.isDoor(n.getPos());
            float tent = this.currentNode.g + this.currentNode.getDistanceFrom(n);
            if (n.closed && tent > n.g || this.qNodes.contains(n) && !(tent < n.g)) continue;
            if (!isPDoor && !isDoor && !isNDoor && this.canSeeParent(n, this.currentNode.parentNode)) {
                n.parentNode = this.currentNode.parentNode;
                n.g = n.parentNode.g + n.getDistanceFrom(n.parentNode);
                n.f = n.g + n.getH(this.tx, this.ty, this.tz);
            } else {
                n.parentNode = this.currentNode;
                n.g = tent;
                n.f = n.g + n.getH(this.tx, this.ty, this.tz);
            }
            if (!this.qNodes.contains(n)) {
                this.qNodes.offer(n);
            }
            n.closed = false;
        }
        return false;
    }

    private boolean shouldTerminateEarly() {
        if (this.runTime > this.maxRunTime) {
            return true;
        }
        if ((long)this.searchIteration > this.maxSearchIterations) {
            return true;
        }
        float dist = this.currentNode.getDistanceFrom(this.tx, this.ty, this.tz);
        float len = this.currentNode.getPathLength();
        if (dist < this.bestPathDist) {
            this.bestEndNode = this.currentNode;
            this.bestPathDist = dist;
            this.bestPathLength = len;
        }
        return len > (float)this.maxRange;
    }

    private boolean canSeeParent(Node n, Node p) {
        if (p == null || n == null) {
            return false;
        }
        return PathUtils.canPathStraightToTargetLevel(this.world, n.x, n.y, n.z, p.x, p.y, p.z);
    }

    private void findNeighbors(Node n) {
        this.searchNodes.clear();
        this.tryAddSearchNode(n.x - 1, n.y, n.z, n);
        this.tryAddSearchNode(n.x + 1, n.y, n.z, n);
        this.tryAddSearchNode(n.x, n.y, n.z - 1, n);
        this.tryAddSearchNode(n.x, n.y, n.z + 1, n);
        if (this.world.isWalkable(n.x, n.y, n.z + 1) && this.world.isWalkable(n.x - 1, n.y, n.z)) {
            this.tryAddSearchNode(n.x - 1, n.y, n.z + 1, n);
        }
        if (this.world.isWalkable(n.x, n.y, n.z + 1) && this.world.isWalkable(n.x + 1, n.y, n.z)) {
            this.tryAddSearchNode(n.x + 1, n.y, n.z + 1, n);
        }
        if (this.world.isWalkable(n.x + 1, n.y, n.z) && this.world.isWalkable(n.x, n.y, n.z - 1)) {
            this.tryAddSearchNode(n.x + 1, n.y, n.z - 1, n);
        }
        if (this.world.isWalkable(n.x - 1, n.y, n.z) && this.world.isWalkable(n.x, n.y, n.z - 1)) {
            this.tryAddSearchNode(n.x - 1, n.y, n.z - 1, n);
        }
        this.tryAddSearchNode(n.x, n.y + 1, n.z, n);
        this.tryAddSearchNode(n.x, n.y - 1, n.z, n);
        this.tryAddSearchNode(n.x - 1, n.y + 1, n.z, n);
        this.tryAddSearchNode(n.x + 1, n.y + 1, n.z, n);
        this.tryAddSearchNode(n.x, n.y + 1, n.z - 1, n);
        this.tryAddSearchNode(n.x, n.y + 1, n.z + 1, n);
        this.tryAddSearchNode(n.x - 1, n.y - 1, n.z, n);
        this.tryAddSearchNode(n.x + 1, n.y - 1, n.z, n);
        this.tryAddSearchNode(n.x, n.y - 1, n.z - 1, n);
        this.tryAddSearchNode(n.x, n.y - 1, n.z + 1, n);
        if (this.world.canDrop) {
            this.tryAddSearchNode(n.x - 1, n.y - 2, n.z, n);
            this.tryAddSearchNode(n.x + 1, n.y - 2, n.z, n);
            this.tryAddSearchNode(n.x, n.y - 2, n.z - 1, n);
            this.tryAddSearchNode(n.x, n.y - 2, n.z + 1, n);
        }
    }

    private void tryAddSearchNode(int x, int y, int z, Node p) {
        if (x < this.minx || x > this.maxx || y < this.miny || y > this.maxy || z < this.minz || z > this.maxz) {
            return;
        }
        if (this.world.isWalkable(x, y, z)) {
            if (p != null && p.y != y && (p.z != z || p.x != x)) {
                if (p.y > y) {
                    if (!this.world.checkBlockBounds(x, y + 2, z)) {
                        return;
                    }
                } else if (p.y < y) {
                    if (this.world.isPartialBlock(p.getPos().func_177977_b())) {
                        return;
                    }
                    if (!this.world.checkBlockBounds(p.x, p.y + 2, p.z)) {
                        return;
                    }
                }
            }
            this.searchNodes.add(this.getOrMakeNode(x, y, z, p));
        }
    }

    private Node getOrMakeNode(int x, int y, int z, Node p) {
        Node n = null;
        for (Node c : this.allNodes) {
            if (!c.equals(x, y, z)) continue;
            return c;
        }
        n = new Node(x, y, z);
        if (p != null) {
            n.travelCost = this.world.getTravelCost(new BlockPos(x, y, z));
            n.parentNode = p;
            n.g = p.g + n.getDistanceFrom(p) + n.travelCost;
            n.f = n.g + n.getDistanceFrom(this.tx, this.ty, this.tz);
        }
        this.allNodes.add(n);
        return n;
    }
}

