/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.network.PacketVehicleBase;

public class PacketVehicleMove
extends PacketVehicleBase {
    private double posX;
    private double posY;
    private double posZ;
    private boolean air;
    private float motion;
    private float yaw;
    private float pitch;

    public PacketVehicleMove() {
    }

    public PacketVehicleMove(VehicleBase vehicle, double posX, double posY, double posZ, boolean air, float motion, float yaw, float pitch) {
        super(vehicle);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.air = air;
        this.motion = motion;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        super.writeToStream(data);
        data.writeDouble(this.posX);
        data.writeDouble(this.posY);
        data.writeDouble(this.posZ);
        data.writeBoolean(this.air);
        data.writeFloat(this.motion);
        data.writeFloat(this.yaw);
        data.writeFloat(this.pitch);
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.posX = data.readDouble();
        this.posY = data.readDouble();
        this.posZ = data.readDouble();
        this.air = data.readBoolean();
        this.motion = data.readFloat();
        this.yaw = data.readFloat();
        this.pitch = data.readFloat();
    }

    @Override
    public void execute() {
        this.vehicle.moveHelper.updateMoveData(this.posX, this.posY, this.posZ, this.air, this.motion, this.yaw, this.pitch);
    }
}

